<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TInvoiceStatus StructType
 * @subpackage Structs
 */
class TInvoiceStatus extends AbstractStructBase
{
    /**
     * The StatusType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusType;
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileID;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDesc;
    /**
     * Constructor method for TInvoiceStatus
     * @uses TInvoiceStatus::setStatusType()
     * @uses TInvoiceStatus::setInvoiceID()
     * @uses TInvoiceStatus::setUUID()
     * @uses TInvoiceStatus::setProfileID()
     * @uses TInvoiceStatus::setInvoiceDate()
     * @uses TInvoiceStatus::setStatus()
     * @uses TInvoiceStatus::setStatusDesc()
     * @param string $statusType
     * @param string $invoiceID
     * @param string $uUID
     * @param string $profileID
     * @param string $invoiceDate
     * @param string $status
     * @param string $statusDesc
     */
    public function __construct($statusType = null, $invoiceID = null, $uUID = null, $profileID = null, $invoiceDate = null, $status = null, $statusDesc = null)
    {
        $this
            ->setStatusType($statusType)
            ->setInvoiceID($invoiceID)
            ->setUUID($uUID)
            ->setProfileID($profileID)
            ->setInvoiceDate($invoiceDate)
            ->setStatus($status)
            ->setStatusDesc($statusDesc);
    }
    /**
     * Get StatusType value
     * @return string
     */
    public function getStatusType()
    {
        return $this->StatusType;
    }
    /**
     * Set StatusType value
     * @uses \EnumType\InvoiceStatusType::valueIsValid()
     * @uses \EnumType\InvoiceStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusType
     * @return \StructType\TInvoiceStatus
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InvoiceStatusType::valueIsValid($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InvoiceStatusType', is_array($statusType) ? implode(', ', $statusType) : var_export($statusType, true), implode(', ', \EnumType\InvoiceStatusType::getValidValues())), __LINE__);
        }
        $this->StatusType = $statusType;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return string|null
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param string $invoiceID
     * @return \StructType\TInvoiceStatus
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceID) && !is_string($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\TInvoiceStatus
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return string|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param string $profileID
     * @return \StructType\TInvoiceStatus
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: string
        if (!is_null($profileID) && !is_string($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\TInvoiceStatus
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\TInvoiceStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusDesc value
     * @return string|null
     */
    public function getStatusDesc()
    {
        return $this->StatusDesc;
    }
    /**
     * Set StatusDesc value
     * @param string $statusDesc
     * @return \StructType\TInvoiceStatus
     */
    public function setStatusDesc($statusDesc = null)
    {
        // validation for constraint: string
        if (!is_null($statusDesc) && !is_string($statusDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDesc, true), gettype($statusDesc)), __LINE__);
        }
        $this->StatusDesc = $statusDesc;
        return $this;
    }
}
