<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TInvoiceResponse StructType
 * @subpackage Structs
 */
class TInvoiceResponse extends AbstractStructBase
{
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceTypeCode;
    /**
     * The CustomerPartyIdentificationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerPartyIdentificationId;
    /**
     * The CustomerPartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerPartyName;
    /**
     * The SupplierPartyIdentificationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierPartyIdentificationId;
    /**
     * The SupplierPartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierPartyName;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayableAmount;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for TInvoiceResponse
     * @uses TInvoiceResponse::setInvoiceID()
     * @uses TInvoiceResponse::setProfileID()
     * @uses TInvoiceResponse::setUUID()
     * @uses TInvoiceResponse::setInvoiceDate()
     * @uses TInvoiceResponse::setInvoiceTypeCode()
     * @uses TInvoiceResponse::setCustomerPartyIdentificationId()
     * @uses TInvoiceResponse::setCustomerPartyName()
     * @uses TInvoiceResponse::setSupplierPartyIdentificationId()
     * @uses TInvoiceResponse::setSupplierPartyName()
     * @uses TInvoiceResponse::setPayableAmount()
     * @uses TInvoiceResponse::setStatus()
     * @param string $invoiceID
     * @param string $profileID
     * @param string $uUID
     * @param string $invoiceDate
     * @param string $invoiceTypeCode
     * @param string $customerPartyIdentificationId
     * @param string $customerPartyName
     * @param string $supplierPartyIdentificationId
     * @param string $supplierPartyName
     * @param string $payableAmount
     * @param string $status
     */
    public function __construct($invoiceID = null, $profileID = null, $uUID = null, $invoiceDate = null, $invoiceTypeCode = null, $customerPartyIdentificationId = null, $customerPartyName = null, $supplierPartyIdentificationId = null, $supplierPartyName = null, $payableAmount = null, $status = null)
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setProfileID($profileID)
            ->setUUID($uUID)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setCustomerPartyIdentificationId($customerPartyIdentificationId)
            ->setCustomerPartyName($customerPartyName)
            ->setSupplierPartyIdentificationId($supplierPartyIdentificationId)
            ->setSupplierPartyName($supplierPartyName)
            ->setPayableAmount($payableAmount)
            ->setStatus($status);
    }
    /**
     * Get InvoiceID value
     * @return string|null
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param string $invoiceID
     * @return \StructType\TInvoiceResponse
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceID) && !is_string($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return string|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param string $profileID
     * @return \StructType\TInvoiceResponse
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: string
        if (!is_null($profileID) && !is_string($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\TInvoiceResponse
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\TInvoiceResponse
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return string|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param string $invoiceTypeCode
     * @return \StructType\TInvoiceResponse
     */
    public function setInvoiceTypeCode($invoiceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTypeCode) && !is_string($invoiceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTypeCode, true), gettype($invoiceTypeCode)), __LINE__);
        }
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get CustomerPartyIdentificationId value
     * @return string|null
     */
    public function getCustomerPartyIdentificationId()
    {
        return $this->CustomerPartyIdentificationId;
    }
    /**
     * Set CustomerPartyIdentificationId value
     * @param string $customerPartyIdentificationId
     * @return \StructType\TInvoiceResponse
     */
    public function setCustomerPartyIdentificationId($customerPartyIdentificationId = null)
    {
        // validation for constraint: string
        if (!is_null($customerPartyIdentificationId) && !is_string($customerPartyIdentificationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPartyIdentificationId, true), gettype($customerPartyIdentificationId)), __LINE__);
        }
        $this->CustomerPartyIdentificationId = $customerPartyIdentificationId;
        return $this;
    }
    /**
     * Get CustomerPartyName value
     * @return string|null
     */
    public function getCustomerPartyName()
    {
        return $this->CustomerPartyName;
    }
    /**
     * Set CustomerPartyName value
     * @param string $customerPartyName
     * @return \StructType\TInvoiceResponse
     */
    public function setCustomerPartyName($customerPartyName = null)
    {
        // validation for constraint: string
        if (!is_null($customerPartyName) && !is_string($customerPartyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPartyName, true), gettype($customerPartyName)), __LINE__);
        }
        $this->CustomerPartyName = $customerPartyName;
        return $this;
    }
    /**
     * Get SupplierPartyIdentificationId value
     * @return string|null
     */
    public function getSupplierPartyIdentificationId()
    {
        return $this->SupplierPartyIdentificationId;
    }
    /**
     * Set SupplierPartyIdentificationId value
     * @param string $supplierPartyIdentificationId
     * @return \StructType\TInvoiceResponse
     */
    public function setSupplierPartyIdentificationId($supplierPartyIdentificationId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierPartyIdentificationId) && !is_string($supplierPartyIdentificationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierPartyIdentificationId, true), gettype($supplierPartyIdentificationId)), __LINE__);
        }
        $this->SupplierPartyIdentificationId = $supplierPartyIdentificationId;
        return $this;
    }
    /**
     * Get SupplierPartyName value
     * @return string|null
     */
    public function getSupplierPartyName()
    {
        return $this->SupplierPartyName;
    }
    /**
     * Set SupplierPartyName value
     * @param string $supplierPartyName
     * @return \StructType\TInvoiceResponse
     */
    public function setSupplierPartyName($supplierPartyName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierPartyName) && !is_string($supplierPartyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierPartyName, true), gettype($supplierPartyName)), __LINE__);
        }
        $this->SupplierPartyName = $supplierPartyName;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return string|null
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param string $payableAmount
     * @return \StructType\TInvoiceResponse
     */
    public function setPayableAmount($payableAmount = null)
    {
        // validation for constraint: string
        if (!is_null($payableAmount) && !is_string($payableAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payableAmount, true), gettype($payableAmount)), __LINE__);
        }
        $this->PayableAmount = $payableAmount;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\TInvoiceResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
