<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TInvoiceInfo StructType
 * @subpackage Structs
 */
class TInvoiceInfo extends AbstractStructBase
{
    /**
     * The Invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TInvoice
     */
    public $Invoice;
    /**
     * The TargetCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TTargetCustomer
     */
    public $TargetCustomer;
    /**
     * The EArchiveInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TEArchiveInvoiceInfo
     */
    public $EArchiveInvoiceInfo;
    /**
     * The EmailAccountIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAccountIdentifier;
    /**
     * The EmailTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTo;
    /**
     * The SenderAlias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAlias;
    /**
     * Constructor method for TInvoiceInfo
     * @uses TInvoiceInfo::setInvoice()
     * @uses TInvoiceInfo::setTargetCustomer()
     * @uses TInvoiceInfo::setEArchiveInvoiceInfo()
     * @uses TInvoiceInfo::setEmailAccountIdentifier()
     * @uses TInvoiceInfo::setEmailTo()
     * @uses TInvoiceInfo::setSenderAlias()
     * @param \StructType\TInvoice $invoice
     * @param \StructType\TTargetCustomer $targetCustomer
     * @param \StructType\TEArchiveInvoiceInfo $eArchiveInvoiceInfo
     * @param string $emailAccountIdentifier
     * @param string $emailTo
     * @param string $senderAlias
     */
    public function __construct(\StructType\TInvoice $invoice = null, \StructType\TTargetCustomer $targetCustomer = null, \StructType\TEArchiveInvoiceInfo $eArchiveInvoiceInfo = null, $emailAccountIdentifier = null, $emailTo = null, $senderAlias = null)
    {
        $this
            ->setInvoice($invoice)
            ->setTargetCustomer($targetCustomer)
            ->setEArchiveInvoiceInfo($eArchiveInvoiceInfo)
            ->setEmailAccountIdentifier($emailAccountIdentifier)
            ->setEmailTo($emailTo)
            ->setSenderAlias($senderAlias);
    }
    /**
     * Get Invoice value
     * @return \StructType\TInvoice|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \StructType\TInvoice $invoice
     * @return \StructType\TInvoiceInfo
     */
    public function setInvoice(\StructType\TInvoice $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get TargetCustomer value
     * @return \StructType\TTargetCustomer|null
     */
    public function getTargetCustomer()
    {
        return $this->TargetCustomer;
    }
    /**
     * Set TargetCustomer value
     * @param \StructType\TTargetCustomer $targetCustomer
     * @return \StructType\TInvoiceInfo
     */
    public function setTargetCustomer(\StructType\TTargetCustomer $targetCustomer = null)
    {
        $this->TargetCustomer = $targetCustomer;
        return $this;
    }
    /**
     * Get EArchiveInvoiceInfo value
     * @return \StructType\TEArchiveInvoiceInfo|null
     */
    public function getEArchiveInvoiceInfo()
    {
        return $this->EArchiveInvoiceInfo;
    }
    /**
     * Set EArchiveInvoiceInfo value
     * @param \StructType\TEArchiveInvoiceInfo $eArchiveInvoiceInfo
     * @return \StructType\TInvoiceInfo
     */
    public function setEArchiveInvoiceInfo(\StructType\TEArchiveInvoiceInfo $eArchiveInvoiceInfo = null)
    {
        $this->EArchiveInvoiceInfo = $eArchiveInvoiceInfo;
        return $this;
    }
    /**
     * Get EmailAccountIdentifier value
     * @return string|null
     */
    public function getEmailAccountIdentifier()
    {
        return $this->EmailAccountIdentifier;
    }
    /**
     * Set EmailAccountIdentifier value
     * @param string $emailAccountIdentifier
     * @return \StructType\TInvoiceInfo
     */
    public function setEmailAccountIdentifier($emailAccountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($emailAccountIdentifier) && !is_string($emailAccountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAccountIdentifier, true), gettype($emailAccountIdentifier)), __LINE__);
        }
        $this->EmailAccountIdentifier = $emailAccountIdentifier;
        return $this;
    }
    /**
     * Get EmailTo value
     * @return string|null
     */
    public function getEmailTo()
    {
        return $this->EmailTo;
    }
    /**
     * Set EmailTo value
     * @param string $emailTo
     * @return \StructType\TInvoiceInfo
     */
    public function setEmailTo($emailTo = null)
    {
        // validation for constraint: string
        if (!is_null($emailTo) && !is_string($emailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTo, true), gettype($emailTo)), __LINE__);
        }
        $this->EmailTo = $emailTo;
        return $this;
    }
    /**
     * Get SenderAlias value
     * @return string|null
     */
    public function getSenderAlias()
    {
        return $this->SenderAlias;
    }
    /**
     * Set SenderAlias value
     * @param string $senderAlias
     * @return \StructType\TInvoiceInfo
     */
    public function setSenderAlias($senderAlias = null)
    {
        // validation for constraint: string
        if (!is_null($senderAlias) && !is_string($senderAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAlias, true), gettype($senderAlias)), __LINE__);
        }
        $this->SenderAlias = $senderAlias;
        return $this;
    }
}
