<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TInvoice StructType
 * @subpackage Structs
 */
class TInvoice extends AbstractStructBase
{
    /**
     * The LineCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineCount;
    /**
     * The PricingExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PricingExchangeRate;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LineExtensionAmount;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxExclusiveAmount;
    /**
     * The TaxInclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxInclusiveAmount;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceTotalAmount;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PayableAmount;
    /**
     * The TaxTotalsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotalsAmount;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The FreightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FreightAmount;
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceTypeCode;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileID;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueTime;
    /**
     * The DespatchIssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DespatchIssueDate;
    /**
     * The DespatchNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DespatchNo;
    /**
     * The UBLVersionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UBLVersionID;
    /**
     * The CustomizationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomizationID;
    /**
     * The SupplierParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TParty
     */
    public $SupplierParty;
    /**
     * The CustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TParty
     */
    public $CustomerParty;
    /**
     * The BuyerCustomerParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TParty
     */
    public $BuyerCustomerParty;
    /**
     * The InvoiceLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTInvoiceLine
     */
    public $InvoiceLines;
    /**
     * The TaxTotals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTTaxTotal
     */
    public $TaxTotals;
    /**
     * The WithholdingTaxTotals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTTaxTotal
     */
    public $WithholdingTaxTotals;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Notes;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTPaymentMeans
     */
    public $PaymentMeans;
    /**
     * The SgkInvoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TSgkInvoiceInfo
     */
    public $SgkInvoiceInfo;
    /**
     * The BillingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TBillingReference
     */
    public $BillingReference;
    /**
     * Constructor method for TInvoice
     * @uses TInvoice::setLineCount()
     * @uses TInvoice::setPricingExchangeRate()
     * @uses TInvoice::setLineExtensionAmount()
     * @uses TInvoice::setTaxExclusiveAmount()
     * @uses TInvoice::setTaxInclusiveAmount()
     * @uses TInvoice::setAllowanceTotalAmount()
     * @uses TInvoice::setPayableAmount()
     * @uses TInvoice::setTaxTotalsAmount()
     * @uses TInvoice::setInsuranceAmount()
     * @uses TInvoice::setFreightAmount()
     * @uses TInvoice::setInvoiceID()
     * @uses TInvoice::setUUID()
     * @uses TInvoice::setInvoiceTypeCode()
     * @uses TInvoice::setProfileID()
     * @uses TInvoice::setCurrencyID()
     * @uses TInvoice::setIssueDate()
     * @uses TInvoice::setIssueTime()
     * @uses TInvoice::setDespatchIssueDate()
     * @uses TInvoice::setDespatchNo()
     * @uses TInvoice::setUBLVersionID()
     * @uses TInvoice::setCustomizationID()
     * @uses TInvoice::setSupplierParty()
     * @uses TInvoice::setCustomerParty()
     * @uses TInvoice::setBuyerCustomerParty()
     * @uses TInvoice::setInvoiceLines()
     * @uses TInvoice::setTaxTotals()
     * @uses TInvoice::setWithholdingTaxTotals()
     * @uses TInvoice::setNotes()
     * @uses TInvoice::setPaymentMeans()
     * @uses TInvoice::setSgkInvoiceInfo()
     * @uses TInvoice::setBillingReference()
     * @param int $lineCount
     * @param float $pricingExchangeRate
     * @param float $lineExtensionAmount
     * @param float $taxExclusiveAmount
     * @param float $taxInclusiveAmount
     * @param float $allowanceTotalAmount
     * @param float $payableAmount
     * @param float $taxTotalsAmount
     * @param float $insuranceAmount
     * @param float $freightAmount
     * @param string $invoiceID
     * @param string $uUID
     * @param string $invoiceTypeCode
     * @param string $profileID
     * @param string $currencyID
     * @param string $issueDate
     * @param string $issueTime
     * @param string $despatchIssueDate
     * @param string $despatchNo
     * @param string $uBLVersionID
     * @param string $customizationID
     * @param \StructType\TParty $supplierParty
     * @param \StructType\TParty $customerParty
     * @param \StructType\TParty $buyerCustomerParty
     * @param \ArrayType\ArrayOfTInvoiceLine $invoiceLines
     * @param \ArrayType\ArrayOfTTaxTotal $taxTotals
     * @param \ArrayType\ArrayOfTTaxTotal $withholdingTaxTotals
     * @param \ArrayType\ArrayOfString $notes
     * @param \ArrayType\ArrayOfTPaymentMeans $paymentMeans
     * @param \StructType\TSgkInvoiceInfo $sgkInvoiceInfo
     * @param \StructType\TBillingReference $billingReference
     */
    public function __construct($lineCount = null, $pricingExchangeRate = null, $lineExtensionAmount = null, $taxExclusiveAmount = null, $taxInclusiveAmount = null, $allowanceTotalAmount = null, $payableAmount = null, $taxTotalsAmount = null, $insuranceAmount = null, $freightAmount = null, $invoiceID = null, $uUID = null, $invoiceTypeCode = null, $profileID = null, $currencyID = null, $issueDate = null, $issueTime = null, $despatchIssueDate = null, $despatchNo = null, $uBLVersionID = null, $customizationID = null, \StructType\TParty $supplierParty = null, \StructType\TParty $customerParty = null, \StructType\TParty $buyerCustomerParty = null, \ArrayType\ArrayOfTInvoiceLine $invoiceLines = null, \ArrayType\ArrayOfTTaxTotal $taxTotals = null, \ArrayType\ArrayOfTTaxTotal $withholdingTaxTotals = null, \ArrayType\ArrayOfString $notes = null, \ArrayType\ArrayOfTPaymentMeans $paymentMeans = null, \StructType\TSgkInvoiceInfo $sgkInvoiceInfo = null, \StructType\TBillingReference $billingReference = null)
    {
        $this
            ->setLineCount($lineCount)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setTaxInclusiveAmount($taxInclusiveAmount)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setPayableAmount($payableAmount)
            ->setTaxTotalsAmount($taxTotalsAmount)
            ->setInsuranceAmount($insuranceAmount)
            ->setFreightAmount($freightAmount)
            ->setInvoiceID($invoiceID)
            ->setUUID($uUID)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setProfileID($profileID)
            ->setCurrencyID($currencyID)
            ->setIssueDate($issueDate)
            ->setIssueTime($issueTime)
            ->setDespatchIssueDate($despatchIssueDate)
            ->setDespatchNo($despatchNo)
            ->setUBLVersionID($uBLVersionID)
            ->setCustomizationID($customizationID)
            ->setSupplierParty($supplierParty)
            ->setCustomerParty($customerParty)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setInvoiceLines($invoiceLines)
            ->setTaxTotals($taxTotals)
            ->setWithholdingTaxTotals($withholdingTaxTotals)
            ->setNotes($notes)
            ->setPaymentMeans($paymentMeans)
            ->setSgkInvoiceInfo($sgkInvoiceInfo)
            ->setBillingReference($billingReference);
    }
    /**
     * Get LineCount value
     * @return int
     */
    public function getLineCount()
    {
        return $this->LineCount;
    }
    /**
     * Set LineCount value
     * @param int $lineCount
     * @return \StructType\TInvoice
     */
    public function setLineCount($lineCount = null)
    {
        // validation for constraint: int
        if (!is_null($lineCount) && !(is_int($lineCount) || ctype_digit($lineCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineCount, true), gettype($lineCount)), __LINE__);
        }
        $this->LineCount = $lineCount;
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * @return float
     */
    public function getPricingExchangeRate()
    {
        return $this->PricingExchangeRate;
    }
    /**
     * Set PricingExchangeRate value
     * @param float $pricingExchangeRate
     * @return \StructType\TInvoice
     */
    public function setPricingExchangeRate($pricingExchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($pricingExchangeRate) && !(is_float($pricingExchangeRate) || is_numeric($pricingExchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pricingExchangeRate, true), gettype($pricingExchangeRate)), __LINE__);
        }
        $this->PricingExchangeRate = $pricingExchangeRate;
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * @return float
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }
    /**
     * Set LineExtensionAmount value
     * @param float $lineExtensionAmount
     * @return \StructType\TInvoice
     */
    public function setLineExtensionAmount($lineExtensionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($lineExtensionAmount) && !(is_float($lineExtensionAmount) || is_numeric($lineExtensionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lineExtensionAmount, true), gettype($lineExtensionAmount)), __LINE__);
        }
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }
    /**
     * Get TaxExclusiveAmount value
     * @return float
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }
    /**
     * Set TaxExclusiveAmount value
     * @param float $taxExclusiveAmount
     * @return \StructType\TInvoice
     */
    public function setTaxExclusiveAmount($taxExclusiveAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxExclusiveAmount) && !(is_float($taxExclusiveAmount) || is_numeric($taxExclusiveAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxExclusiveAmount, true), gettype($taxExclusiveAmount)), __LINE__);
        }
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }
    /**
     * Get TaxInclusiveAmount value
     * @return float
     */
    public function getTaxInclusiveAmount()
    {
        return $this->TaxInclusiveAmount;
    }
    /**
     * Set TaxInclusiveAmount value
     * @param float $taxInclusiveAmount
     * @return \StructType\TInvoice
     */
    public function setTaxInclusiveAmount($taxInclusiveAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxInclusiveAmount) && !(is_float($taxInclusiveAmount) || is_numeric($taxInclusiveAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxInclusiveAmount, true), gettype($taxInclusiveAmount)), __LINE__);
        }
        $this->TaxInclusiveAmount = $taxInclusiveAmount;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return float
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param float $allowanceTotalAmount
     * @return \StructType\TInvoice
     */
    public function setAllowanceTotalAmount($allowanceTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceTotalAmount) && !(is_float($allowanceTotalAmount) || is_numeric($allowanceTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceTotalAmount, true), gettype($allowanceTotalAmount)), __LINE__);
        }
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get PayableAmount value
     * @return float
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }
    /**
     * Set PayableAmount value
     * @param float $payableAmount
     * @return \StructType\TInvoice
     */
    public function setPayableAmount($payableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($payableAmount) && !(is_float($payableAmount) || is_numeric($payableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payableAmount, true), gettype($payableAmount)), __LINE__);
        }
        $this->PayableAmount = $payableAmount;
        return $this;
    }
    /**
     * Get TaxTotalsAmount value
     * @return float
     */
    public function getTaxTotalsAmount()
    {
        return $this->TaxTotalsAmount;
    }
    /**
     * Set TaxTotalsAmount value
     * @param float $taxTotalsAmount
     * @return \StructType\TInvoice
     */
    public function setTaxTotalsAmount($taxTotalsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotalsAmount) && !(is_float($taxTotalsAmount) || is_numeric($taxTotalsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotalsAmount, true), gettype($taxTotalsAmount)), __LINE__);
        }
        $this->TaxTotalsAmount = $taxTotalsAmount;
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \StructType\TInvoice
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get FreightAmount value
     * @return float
     */
    public function getFreightAmount()
    {
        return $this->FreightAmount;
    }
    /**
     * Set FreightAmount value
     * @param float $freightAmount
     * @return \StructType\TInvoice
     */
    public function setFreightAmount($freightAmount = null)
    {
        // validation for constraint: float
        if (!is_null($freightAmount) && !(is_float($freightAmount) || is_numeric($freightAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freightAmount, true), gettype($freightAmount)), __LINE__);
        }
        $this->FreightAmount = $freightAmount;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return string|null
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param string $invoiceID
     * @return \StructType\TInvoice
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceID) && !is_string($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\TInvoice
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return string|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param string $invoiceTypeCode
     * @return \StructType\TInvoice
     */
    public function setInvoiceTypeCode($invoiceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTypeCode) && !is_string($invoiceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTypeCode, true), gettype($invoiceTypeCode)), __LINE__);
        }
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return string|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param string $profileID
     * @return \StructType\TInvoice
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: string
        if (!is_null($profileID) && !is_string($profileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get CurrencyID value
     * @return string|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @param string $currencyID
     * @return \StructType\TInvoice
     */
    public function setCurrencyID($currencyID = null)
    {
        // validation for constraint: string
        if (!is_null($currencyID) && !is_string($currencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyID, true), gettype($currencyID)), __LINE__);
        }
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\TInvoice
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueTime value
     * @return string|null
     */
    public function getIssueTime()
    {
        return $this->IssueTime;
    }
    /**
     * Set IssueTime value
     * @param string $issueTime
     * @return \StructType\TInvoice
     */
    public function setIssueTime($issueTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueTime) && !is_string($issueTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueTime, true), gettype($issueTime)), __LINE__);
        }
        $this->IssueTime = $issueTime;
        return $this;
    }
    /**
     * Get DespatchIssueDate value
     * @return string|null
     */
    public function getDespatchIssueDate()
    {
        return $this->DespatchIssueDate;
    }
    /**
     * Set DespatchIssueDate value
     * @param string $despatchIssueDate
     * @return \StructType\TInvoice
     */
    public function setDespatchIssueDate($despatchIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($despatchIssueDate) && !is_string($despatchIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchIssueDate, true), gettype($despatchIssueDate)), __LINE__);
        }
        $this->DespatchIssueDate = $despatchIssueDate;
        return $this;
    }
    /**
     * Get DespatchNo value
     * @return string|null
     */
    public function getDespatchNo()
    {
        return $this->DespatchNo;
    }
    /**
     * Set DespatchNo value
     * @param string $despatchNo
     * @return \StructType\TInvoice
     */
    public function setDespatchNo($despatchNo = null)
    {
        // validation for constraint: string
        if (!is_null($despatchNo) && !is_string($despatchNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchNo, true), gettype($despatchNo)), __LINE__);
        }
        $this->DespatchNo = $despatchNo;
        return $this;
    }
    /**
     * Get UBLVersionID value
     * @return string|null
     */
    public function getUBLVersionID()
    {
        return $this->UBLVersionID;
    }
    /**
     * Set UBLVersionID value
     * @param string $uBLVersionID
     * @return \StructType\TInvoice
     */
    public function setUBLVersionID($uBLVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($uBLVersionID) && !is_string($uBLVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uBLVersionID, true), gettype($uBLVersionID)), __LINE__);
        }
        $this->UBLVersionID = $uBLVersionID;
        return $this;
    }
    /**
     * Get CustomizationID value
     * @return string|null
     */
    public function getCustomizationID()
    {
        return $this->CustomizationID;
    }
    /**
     * Set CustomizationID value
     * @param string $customizationID
     * @return \StructType\TInvoice
     */
    public function setCustomizationID($customizationID = null)
    {
        // validation for constraint: string
        if (!is_null($customizationID) && !is_string($customizationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customizationID, true), gettype($customizationID)), __LINE__);
        }
        $this->CustomizationID = $customizationID;
        return $this;
    }
    /**
     * Get SupplierParty value
     * @return \StructType\TParty|null
     */
    public function getSupplierParty()
    {
        return $this->SupplierParty;
    }
    /**
     * Set SupplierParty value
     * @param \StructType\TParty $supplierParty
     * @return \StructType\TInvoice
     */
    public function setSupplierParty(\StructType\TParty $supplierParty = null)
    {
        $this->SupplierParty = $supplierParty;
        return $this;
    }
    /**
     * Get CustomerParty value
     * @return \StructType\TParty|null
     */
    public function getCustomerParty()
    {
        return $this->CustomerParty;
    }
    /**
     * Set CustomerParty value
     * @param \StructType\TParty $customerParty
     * @return \StructType\TInvoice
     */
    public function setCustomerParty(\StructType\TParty $customerParty = null)
    {
        $this->CustomerParty = $customerParty;
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * @return \StructType\TParty|null
     */
    public function getBuyerCustomerParty()
    {
        return $this->BuyerCustomerParty;
    }
    /**
     * Set BuyerCustomerParty value
     * @param \StructType\TParty $buyerCustomerParty
     * @return \StructType\TInvoice
     */
    public function setBuyerCustomerParty(\StructType\TParty $buyerCustomerParty = null)
    {
        $this->BuyerCustomerParty = $buyerCustomerParty;
        return $this;
    }
    /**
     * Get InvoiceLines value
     * @return \ArrayType\ArrayOfTInvoiceLine|null
     */
    public function getInvoiceLines()
    {
        return $this->InvoiceLines;
    }
    /**
     * Set InvoiceLines value
     * @param \ArrayType\ArrayOfTInvoiceLine $invoiceLines
     * @return \StructType\TInvoice
     */
    public function setInvoiceLines(\ArrayType\ArrayOfTInvoiceLine $invoiceLines = null)
    {
        $this->InvoiceLines = $invoiceLines;
        return $this;
    }
    /**
     * Get TaxTotals value
     * @return \ArrayType\ArrayOfTTaxTotal|null
     */
    public function getTaxTotals()
    {
        return $this->TaxTotals;
    }
    /**
     * Set TaxTotals value
     * @param \ArrayType\ArrayOfTTaxTotal $taxTotals
     * @return \StructType\TInvoice
     */
    public function setTaxTotals(\ArrayType\ArrayOfTTaxTotal $taxTotals = null)
    {
        $this->TaxTotals = $taxTotals;
        return $this;
    }
    /**
     * Get WithholdingTaxTotals value
     * @return \ArrayType\ArrayOfTTaxTotal|null
     */
    public function getWithholdingTaxTotals()
    {
        return $this->WithholdingTaxTotals;
    }
    /**
     * Set WithholdingTaxTotals value
     * @param \ArrayType\ArrayOfTTaxTotal $withholdingTaxTotals
     * @return \StructType\TInvoice
     */
    public function setWithholdingTaxTotals(\ArrayType\ArrayOfTTaxTotal $withholdingTaxTotals = null)
    {
        $this->WithholdingTaxTotals = $withholdingTaxTotals;
        return $this;
    }
    /**
     * Get Notes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \ArrayType\ArrayOfString $notes
     * @return \StructType\TInvoice
     */
    public function setNotes(\ArrayType\ArrayOfString $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return \ArrayType\ArrayOfTPaymentMeans|null
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * Set PaymentMeans value
     * @param \ArrayType\ArrayOfTPaymentMeans $paymentMeans
     * @return \StructType\TInvoice
     */
    public function setPaymentMeans(\ArrayType\ArrayOfTPaymentMeans $paymentMeans = null)
    {
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Get SgkInvoiceInfo value
     * @return \StructType\TSgkInvoiceInfo|null
     */
    public function getSgkInvoiceInfo()
    {
        return $this->SgkInvoiceInfo;
    }
    /**
     * Set SgkInvoiceInfo value
     * @param \StructType\TSgkInvoiceInfo $sgkInvoiceInfo
     * @return \StructType\TInvoice
     */
    public function setSgkInvoiceInfo(\StructType\TSgkInvoiceInfo $sgkInvoiceInfo = null)
    {
        $this->SgkInvoiceInfo = $sgkInvoiceInfo;
        return $this;
    }
    /**
     * Get BillingReference value
     * @return \StructType\TBillingReference|null
     */
    public function getBillingReference()
    {
        return $this->BillingReference;
    }
    /**
     * Set BillingReference value
     * @param \StructType\TBillingReference $billingReference
     * @return \StructType\TInvoice
     */
    public function setBillingReference(\StructType\TBillingReference $billingReference = null)
    {
        $this->BillingReference = $billingReference;
        return $this;
    }
}
