<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDeliveryAddressType StructType
 * @subpackage Structs
 */
class TDeliveryAddressType extends AbstractStructBase
{
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Room;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetName;
    /**
     * The BuildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingNumber;
    /**
     * The CitySubdivisionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CitySubdivisionName;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The PostalZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalZone;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for TDeliveryAddressType
     * @uses TDeliveryAddressType::setRoom()
     * @uses TDeliveryAddressType::setStreetName()
     * @uses TDeliveryAddressType::setBuildingName()
     * @uses TDeliveryAddressType::setBuildingNumber()
     * @uses TDeliveryAddressType::setCitySubdivisionName()
     * @uses TDeliveryAddressType::setCityName()
     * @uses TDeliveryAddressType::setPostalZone()
     * @uses TDeliveryAddressType::setCountryName()
     * @uses TDeliveryAddressType::setCountryCode()
     * @param string $room
     * @param string $streetName
     * @param string $buildingName
     * @param string $buildingNumber
     * @param string $citySubdivisionName
     * @param string $cityName
     * @param string $postalZone
     * @param string $countryName
     * @param string $countryCode
     */
    public function __construct($room = null, $streetName = null, $buildingName = null, $buildingNumber = null, $citySubdivisionName = null, $cityName = null, $postalZone = null, $countryName = null, $countryCode = null)
    {
        $this
            ->setRoom($room)
            ->setStreetName($streetName)
            ->setBuildingName($buildingName)
            ->setBuildingNumber($buildingNumber)
            ->setCitySubdivisionName($citySubdivisionName)
            ->setCityName($cityName)
            ->setPostalZone($postalZone)
            ->setCountryName($countryName)
            ->setCountryCode($countryCode);
    }
    /**
     * Get Room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param string $room
     * @return \StructType\TDeliveryAddressType
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\TDeliveryAddressType
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get BuildingName value
     * @return string|null
     */
    public function getBuildingName()
    {
        return $this->BuildingName;
    }
    /**
     * Set BuildingName value
     * @param string $buildingName
     * @return \StructType\TDeliveryAddressType
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        $this->BuildingName = $buildingName;
        return $this;
    }
    /**
     * Get BuildingNumber value
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return $this->BuildingNumber;
    }
    /**
     * Set BuildingNumber value
     * @param string $buildingNumber
     * @return \StructType\TDeliveryAddressType
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNumber, true), gettype($buildingNumber)), __LINE__);
        }
        $this->BuildingNumber = $buildingNumber;
        return $this;
    }
    /**
     * Get CitySubdivisionName value
     * @return string|null
     */
    public function getCitySubdivisionName()
    {
        return $this->CitySubdivisionName;
    }
    /**
     * Set CitySubdivisionName value
     * @param string $citySubdivisionName
     * @return \StructType\TDeliveryAddressType
     */
    public function setCitySubdivisionName($citySubdivisionName = null)
    {
        // validation for constraint: string
        if (!is_null($citySubdivisionName) && !is_string($citySubdivisionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citySubdivisionName, true), gettype($citySubdivisionName)), __LINE__);
        }
        $this->CitySubdivisionName = $citySubdivisionName;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\TDeliveryAddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get PostalZone value
     * @return string|null
     */
    public function getPostalZone()
    {
        return $this->PostalZone;
    }
    /**
     * Set PostalZone value
     * @param string $postalZone
     * @return \StructType\TDeliveryAddressType
     */
    public function setPostalZone($postalZone = null)
    {
        // validation for constraint: string
        if (!is_null($postalZone) && !is_string($postalZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalZone, true), gettype($postalZone)), __LINE__);
        }
        $this->PostalZone = $postalZone;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\TDeliveryAddressType
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\TDeliveryAddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
}
