<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DumpInvoice StructType
 * @subpackage Structs
 */
class DumpInvoice extends AbstractStructBase
{
    /**
     * The dataType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dataType;
    /**
     * The invoiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TInvoiceInfo
     */
    public $invoiceInfo;
    /**
     * Constructor method for DumpInvoice
     * @uses DumpInvoice::setDataType()
     * @uses DumpInvoice::setInvoiceInfo()
     * @param string $dataType
     * @param \StructType\TInvoiceInfo $invoiceInfo
     */
    public function __construct($dataType = null, \StructType\TInvoiceInfo $invoiceInfo = null)
    {
        $this
            ->setDataType($dataType)
            ->setInvoiceInfo($invoiceInfo);
    }
    /**
     * Get dataType value
     * @return string
     */
    public function getDataType()
    {
        return $this->dataType;
    }
    /**
     * Set dataType value
     * @uses \EnumType\DataType::valueIsValid()
     * @uses \EnumType\DataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataType
     * @return \StructType\DumpInvoice
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DataType::valueIsValid($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DataType', is_array($dataType) ? implode(', ', $dataType) : var_export($dataType, true), implode(', ', \EnumType\DataType::getValidValues())), __LINE__);
        }
        $this->dataType = $dataType;
        return $this;
    }
    /**
     * Get invoiceInfo value
     * @return \StructType\TInvoiceInfo|null
     */
    public function getInvoiceInfo()
    {
        return $this->invoiceInfo;
    }
    /**
     * Set invoiceInfo value
     * @param \StructType\TInvoiceInfo $invoiceInfo
     * @return \StructType\DumpInvoice
     */
    public function setInvoiceInfo(\StructType\TInvoiceInfo $invoiceInfo = null)
    {
        $this->invoiceInfo = $invoiceInfo;
        return $this;
    }
}
