<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Version ServiceType
 * @subpackage Services
 */
class Version extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VersionInfo
     * Meta information extracted from the WSDL
     * - documentation: Returns version information of invoice services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VersionInfo $parameters
     * @return \StructType\VersionInfoResponse|bool
     */
    public function VersionInfo(\StructType\VersionInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VersionInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VersionInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
