<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TestInvoiceStatus
     * Meta information extracted from the WSDL
     * - documentation: [TEST] Returns current statuses of invoices in status request model.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestInvoiceStatus $parameters
     * @return \StructType\TestInvoiceStatusResponse|bool
     */
    public function TestInvoiceStatus(\StructType\TestInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TestInvoiceStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
