<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendInvoice
     * Meta information extracted from the WSDL
     * - documentation: Sends your enveloped invoices to regulator and GIB systems.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoice $parameters
     * @return \StructType\SendInvoiceResponse|bool
     */
    public function SendInvoice(\StructType\SendInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDraftInvoice
     * Meta information extracted from the WSDL
     * - documentation: Sends your enveloped draft invoices to regulator and GIB systems.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendDraftInvoice $parameters
     * @return \StructType\SendDraftInvoiceResponse|bool
     */
    public function SendDraftInvoice(\StructType\SendDraftInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDraftInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceStatus
     * Meta information extracted from the WSDL
     * - documentation: Finds your alias and basic informations from GIB system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceStatus $parameters
     * @return \StructType\SendInvoiceStatusResponse|bool
     */
    public function SendInvoiceStatus(\StructType\SendInvoiceStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoiceStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendDraftInvoiceResponse|\StructType\SendInvoiceResponse|\StructType\SendInvoiceStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
