<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dump ServiceType
 * @subpackage Services
 */
class Dump extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DumpInvoice
     * Meta information extracted from the WSDL
     * - documentation: Converts your invoice object to selected data type (c#, json, xml)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DumpInvoice $parameters
     * @return \StructType\DumpInvoiceResponse|bool
     */
    public function DumpInvoice(\StructType\DumpInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DumpInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DumpGibUsers
     * Meta information extracted from the WSDL
     * - documentation: Converts your gib users object to selected data type (c#, json, xml)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DumpGibUsers $parameters
     * @return \StructType\DumpGibUsersResponse|bool
     */
    public function DumpGibUsers(\StructType\DumpGibUsers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DumpGibUsers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DumpGibUsersResponse|\StructType\DumpInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
