<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckLicense
     * Meta information extracted from the WSDL
     * - documentation: Checks license is valid or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckLicense $parameters
     * @return \StructType\CheckLicenseResponse|bool
     */
    public function CheckLicense(\StructType\CheckLicense $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckLicense($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckUser
     * Meta information extracted from the WSDL
     * - documentation: Finds your alias and basic informations from GIB system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckUser $parameters
     * @return \StructType\CheckUserResponse|bool
     */
    public function CheckUser(\StructType\CheckUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckUserList $parameters
     * @return \StructType\CheckUserListResponse|bool
     */
    public function CheckUserList(\StructType\CheckUserList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckUserList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckUserListAsync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckUserListAsync $parameters
     * @return \StructType\CheckUserListAsyncResponse|bool
     */
    public function CheckUserListAsync(\StructType\CheckUserListAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckUserListAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckLicenseResponse|\StructType\CheckUserListAsyncResponse|\StructType\CheckUserListResponse|\StructType\CheckUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
