<?php

namespace Casa\ActiviaPrestador\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExecuteFileTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Casa\ActiviaPrestador\StructType\ExecuteFileTransaction $parameters
     * @return \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionResponse|bool
     */
    public function ExecuteFileTransaction(\Casa\ActiviaPrestador\StructType\ExecuteFileTransaction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExecuteFileTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExecuteFileTransactionSL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionSL $parameters
     * @return \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionSLResponse|bool
     */
    public function ExecuteFileTransactionSL(\Casa\ActiviaPrestador\StructType\ExecuteFileTransactionSL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExecuteFileTransactionSL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExecuteFileTransactionAO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionAO $parameters
     * @return \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionAOResponse|bool
     */
    public function ExecuteFileTransactionAO(\Casa\ActiviaPrestador\StructType\ExecuteFileTransactionAO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExecuteFileTransactionAO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionAOResponse|\Casa\ActiviaPrestador\StructType\ExecuteFileTransactionResponse|\Casa\ActiviaPrestador\StructType\ExecuteFileTransactionSLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
