<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Casa\ActiviaPrestador\ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \Casa\ActiviaPrestador\ServiceType\Hello($options);
/**
 * Sample call for HelloWorld operation/method
 */
if ($hello->HelloWorld(new \Casa\ActiviaPrestador\StructType\HelloWorld()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \Casa\ActiviaPrestador\ServiceType\Execute($options);
/**
 * Sample call for ExecuteFileTransaction operation/method
 */
if ($execute->ExecuteFileTransaction(new \Casa\ActiviaPrestador\StructType\ExecuteFileTransaction()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Sample call for ExecuteFileTransactionSL operation/method
 */
if ($execute->ExecuteFileTransactionSL(new \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionSL()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Sample call for ExecuteFileTransactionAO operation/method
 */
if ($execute->ExecuteFileTransactionAO(new \Casa\ActiviaPrestador\StructType\ExecuteFileTransactionAO()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
