<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Preload ServiceType
 */
$preload = new \ServiceType\Preload($options);
/**
 * Sample call for Preload operation/method
 */
if ($preload->Preload(new \StructType\Preload()) !== false) {
    print_r($preload->getResult());
} else {
    print_r($preload->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
/**
 * Sample call for AuthenticateCredentials operation/method
 */
if ($authenticate->AuthenticateCredentials(new \StructType\AuthenticateCredentials()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Sale ServiceType
 */
$sale = new \ServiceType\Sale($options);
/**
 * Sample call for SaleConfiguration operation/method
 */
if ($sale->SaleConfiguration(new \StructType\SaleConfiguration()) !== false) {
    print_r($sale->getResult());
} else {
    print_r($sale->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetValueCodeList operation/method
 */
if ($get->GetValueCodeList(new \StructType\GetValueCodeList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetValueCodes operation/method
 */
if ($get->GetValueCodes(new \StructType\GetValueCodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Eligible ServiceType
 */
$eligible = new \ServiceType\Eligible($options);
/**
 * Sample call for EligibleOriginDestinations operation/method
 */
if ($eligible->EligibleOriginDestinations(new \StructType\EligibleOriginDestinations()) !== false) {
    print_r($eligible->getResult());
} else {
    print_r($eligible->getLastError());
}
/**
 * Samples for Calendar ServiceType
 */
$calendar = new \ServiceType\Calendar($options);
/**
 * Sample call for Calendar operation/method
 */
if ($calendar->Calendar(new \StructType\Calendar()) !== false) {
    print_r($calendar->getResult());
} else {
    print_r($calendar->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for SearchFlights operation/method
 */
if ($search->SearchFlights(new \StructType\SearchFlights()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchBooking operation/method
 */
if ($search->SearchBooking(new \StructType\SearchBooking()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchFlightsForExchange operation/method
 */
if ($search->SearchFlightsForExchange(new \StructType\SearchFlightsForExchange()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchFlightsForAdditionalItinerary operation/method
 */
if ($search->SearchFlightsForAdditionalItinerary(new \StructType\SearchFlightsForAdditionalItinerary()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchServices operation/method
 */
if ($search->SearchServices(new \StructType\SearchServices()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Prepare ServiceType
 */
$prepare = new \ServiceType\Prepare($options);
/**
 * Sample call for PrepareFlights operation/method
 */
if ($prepare->PrepareFlights(new \StructType\PrepareFlights()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareBookingModification operation/method
 */
if ($prepare->PrepareBookingModification(new \StructType\PrepareBookingModification()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareExchange operation/method
 */
if ($prepare->PrepareExchange(new \StructType\PrepareExchange()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareAdditionalItinerary operation/method
 */
if ($prepare->PrepareAdditionalItinerary(new \StructType\PrepareAdditionalItinerary()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareCheckin operation/method
 */
if ($prepare->PrepareCheckin(new \StructType\PrepareCheckin()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareCancel operation/method
 */
if ($prepare->PrepareCancel(new \StructType\PrepareCancel()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateBooking operation/method
 */
if ($create->CreateBooking(new \StructType\CreateBooking()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateTicket operation/method
 */
if ($create->CreateTicket(new \StructType\CreateTicket()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Load ServiceType
 */
$load = new \ServiceType\Load($options);
/**
 * Sample call for LoadBooking operation/method
 */
if ($load->LoadBooking(new \StructType\LoadBooking()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadMCOTickets operation/method
 */
if ($load->LoadMCOTickets(new \StructType\LoadMCOTickets()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadECoupons operation/method
 */
if ($load->LoadECoupons(new \StructType\LoadECoupons()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadCustomer operation/method
 */
if ($load->LoadCustomer(new \StructType\LoadCustomer()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadFrequentFlyerAccount operation/method
 */
if ($load->LoadFrequentFlyerAccount(new \StructType\LoadFrequentFlyerAccount()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for SendTicketConfirmation operation/method
 */
if ($send->SendTicketConfirmation(new \StructType\SendTicketConfirmation()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendCustomerRemovalRequest operation/method
 */
if ($send->SendCustomerRemovalRequest(new \StructType\SendCustomerRemovalRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for ModifyBooking operation/method
 */
if ($modify->ModifyBooking(new \StructType\ModifyBooking()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Split ServiceType
 */
$split = new \ServiceType\Split($options);
/**
 * Sample call for SplitBooking operation/method
 */
if ($split->SplitBooking(new \StructType\SplitBooking()) !== false) {
    print_r($split->getResult());
} else {
    print_r($split->getLastError());
}
/**
 * Samples for Exchange ServiceType
 */
$exchange = new \ServiceType\Exchange($options);
/**
 * Sample call for Exchange operation/method
 */
if ($exchange->Exchange(new \StructType\Exchange()) !== false) {
    print_r($exchange->getResult());
} else {
    print_r($exchange->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelPendingExchange operation/method
 */
if ($cancel->CancelPendingExchange(new \StructType\CancelPendingExchange()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for Cancel operation/method
 */
if ($cancel->Cancel(new \StructType\Cancel()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddItinerary operation/method
 */
if ($add->AddItinerary(new \StructType\AddItinerary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Checkin ServiceType
 */
$checkin = new \ServiceType\Checkin($options);
/**
 * Sample call for Checkin operation/method
 */
if ($checkin->Checkin(new \StructType\Checkin()) !== false) {
    print_r($checkin->getResult());
} else {
    print_r($checkin->getLastError());
}
/**
 * Samples for Uncheck ServiceType
 */
$uncheck = new \ServiceType\Uncheck($options);
/**
 * Sample call for Uncheck operation/method
 */
if ($uncheck->Uncheck(new \StructType\Uncheck()) !== false) {
    print_r($uncheck->getResult());
} else {
    print_r($uncheck->getLastError());
}
/**
 * Samples for Buy ServiceType
 */
$buy = new \ServiceType\Buy($options);
/**
 * Sample call for BuyServices operation/method
 */
if ($buy->BuyServices(new \StructType\BuyServices()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Samples for New ServiceType
 */
$new = new \ServiceType\_New($options);
/**
 * Sample call for NewCustomer operation/method
 */
if ($new->NewCustomer(new \StructType\NewCustomer()) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateCustomer operation/method
 */
if ($update->UpdateCustomer(new \StructType\UpdateCustomer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Lost ServiceType
 */
$lost = new \ServiceType\Lost($options);
/**
 * Sample call for LostCustomerPassword operation/method
 */
if ($lost->LostCustomerPassword(new \StructType\LostCustomerPassword()) !== false) {
    print_r($lost->getResult());
} else {
    print_r($lost->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangeCustomerPassword operation/method
 */
if ($change->ChangeCustomerPassword(new \StructType\ChangeCustomerPassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \ServiceType\Customer($options);
/**
 * Sample call for CustomerPasswordPolicies operation/method
 */
if ($customer->CustomerPasswordPolicies(new \StructType\CustomerPasswordPolicies()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \ServiceType\Activate($options);
/**
 * Sample call for ActivateFrequentFlyerAccount operation/method
 */
if ($activate->ActivateFrequentFlyerAccount(new \StructType\ActivateFrequentFlyerAccount()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Samples for Frequent ServiceType
 */
$frequent = new \ServiceType\Frequent($options);
/**
 * Sample call for FrequentFlyerMileageCalculator operation/method
 */
if ($frequent->FrequentFlyerMileageCalculator(new \StructType\FrequentFlyerMileageCalculator()) !== false) {
    print_r($frequent->getResult());
} else {
    print_r($frequent->getLastError());
}
/**
 * Samples for Event ServiceType
 */
$event = new \ServiceType\Event($options);
/**
 * Sample call for EventMap operation/method
 */
if ($event->EventMap(new \StructType\EventMap()) !== false) {
    print_r($event->getResult());
} else {
    print_r($event->getLastError());
}
/**
 * Samples for Flown ServiceType
 */
$flown = new \ServiceType\Flown($options);
/**
 * Sample call for FlownCoupons operation/method
 */
if ($flown->FlownCoupons(new \StructType\FlownCoupons()) !== false) {
    print_r($flown->getResult());
} else {
    print_r($flown->getLastError());
}
/**
 * Samples for Flight ServiceType
 */
$flight = new \ServiceType\Flight($options);
/**
 * Sample call for FlightStatus operation/method
 */
if ($flight->FlightStatus(new \StructType\FlightStatus()) !== false) {
    print_r($flight->getResult());
} else {
    print_r($flight->getLastError());
}
