<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XElementList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XElementList
 * @subpackage Structs
 */
class XElementList extends AbstractStructBase
{
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Extension[]
     */
    public $Extension;
    /**
     * Constructor method for XElementList
     * @uses XElementList::setExtension()
     * @param \StructType\Extension[] $extension
     */
    public function __construct(array $extension = array())
    {
        $this
            ->setExtension($extension);
    }
    /**
     * Get Extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Extension[]|null
     */
    public function getExtension()
    {
        return isset($this->Extension) ? $this->Extension : null;
    }
    /**
     * This method is responsible for validating the values passed to the setExtension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionForArrayConstraintsFromSetExtension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xElementListExtensionItem) {
            // validation for constraint: itemType
            if (!$xElementListExtensionItem instanceof \StructType\Extension) {
                $invalidValues[] = is_object($xElementListExtensionItem) ? get_class($xElementListExtensionItem) : sprintf('%s(%s)', gettype($xElementListExtensionItem), var_export($xElementListExtensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Extension property can only contain items of type \StructType\Extension, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Extension[] $extension
     * @return \StructType\XElementList
     */
    public function setExtension(array $extension = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionArrayErrorMessage = self::validateExtensionForArrayConstraintsFromSetExtension($extension))) {
            throw new \InvalidArgumentException($extensionArrayErrorMessage, __LINE__);
        }
        if (is_null($extension) || (is_array($extension) && empty($extension))) {
            unset($this->Extension);
        } else {
            $this->Extension = $extension;
        }
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \StructType\Extension $item
     * @return \StructType\XElementList
     */
    public function addToExtension(\StructType\Extension $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Extension) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of type \StructType\Extension, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
}
