<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketInfo
 * @subpackage Structs
 */
class TicketInfo extends ApiObject
{
    /**
     * The EMDTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEMDTicket
     */
    public $EMDTickets;
    /**
     * The ETTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfETTicket
     */
    public $ETTickets;
    /**
     * The Fops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFop
     */
    public $Fops;
    /**
     * Constructor method for TicketInfo
     * @uses TicketInfo::setEMDTickets()
     * @uses TicketInfo::setETTickets()
     * @uses TicketInfo::setFops()
     * @param \ArrayType\ArrayOfEMDTicket $eMDTickets
     * @param \ArrayType\ArrayOfETTicket $eTTickets
     * @param \ArrayType\ArrayOfFop $fops
     */
    public function __construct(\ArrayType\ArrayOfEMDTicket $eMDTickets = null, \ArrayType\ArrayOfETTicket $eTTickets = null, \ArrayType\ArrayOfFop $fops = null)
    {
        $this
            ->setEMDTickets($eMDTickets)
            ->setETTickets($eTTickets)
            ->setFops($fops);
    }
    /**
     * Get EMDTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEMDTicket|null
     */
    public function getEMDTickets()
    {
        return isset($this->EMDTickets) ? $this->EMDTickets : null;
    }
    /**
     * Set EMDTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEMDTicket $eMDTickets
     * @return \StructType\TicketInfo
     */
    public function setEMDTickets(\ArrayType\ArrayOfEMDTicket $eMDTickets = null)
    {
        if (is_null($eMDTickets) || (is_array($eMDTickets) && empty($eMDTickets))) {
            unset($this->EMDTickets);
        } else {
            $this->EMDTickets = $eMDTickets;
        }
        return $this;
    }
    /**
     * Get ETTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfETTicket|null
     */
    public function getETTickets()
    {
        return isset($this->ETTickets) ? $this->ETTickets : null;
    }
    /**
     * Set ETTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfETTicket $eTTickets
     * @return \StructType\TicketInfo
     */
    public function setETTickets(\ArrayType\ArrayOfETTicket $eTTickets = null)
    {
        if (is_null($eTTickets) || (is_array($eTTickets) && empty($eTTickets))) {
            unset($this->ETTickets);
        } else {
            $this->ETTickets = $eTTickets;
        }
        return $this;
    }
    /**
     * Get Fops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFop|null
     */
    public function getFops()
    {
        return isset($this->Fops) ? $this->Fops : null;
    }
    /**
     * Set Fops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFop $fops
     * @return \StructType\TicketInfo
     */
    public function setFops(\ArrayType\ArrayOfFop $fops = null)
    {
        if (is_null($fops) || (is_array($fops) && empty($fops))) {
            unset($this->Fops);
        } else {
            $this->Fops = $fops;
        }
        return $this;
    }
}
