<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceDataFoid StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialServiceDataFoid
 * @subpackage Structs
 */
class SpecialServiceDataFoid extends ApiObject
{
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber;
    /**
     * The DocumentTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeCode;
    /**
     * Constructor method for SpecialServiceDataFoid
     * @uses SpecialServiceDataFoid::setDocumentNumber()
     * @uses SpecialServiceDataFoid::setDocumentTypeCode()
     * @param string $documentNumber
     * @param string $documentTypeCode
     */
    public function __construct($documentNumber = null, $documentTypeCode = null)
    {
        $this
            ->setDocumentNumber($documentNumber)
            ->setDocumentTypeCode($documentTypeCode);
    }
    /**
     * Get DocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return isset($this->DocumentNumber) ? $this->DocumentNumber : null;
    }
    /**
     * Set DocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentNumber
     * @return \StructType\SpecialServiceDataFoid
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        if (is_null($documentNumber) || (is_array($documentNumber) && empty($documentNumber))) {
            unset($this->DocumentNumber);
        } else {
            $this->DocumentNumber = $documentNumber;
        }
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeCode()
    {
        return isset($this->DocumentTypeCode) ? $this->DocumentTypeCode : null;
    }
    /**
     * Set DocumentTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeCode
     * @return \StructType\SpecialServiceDataFoid
     */
    public function setDocumentTypeCode($documentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeCode) && !is_string($documentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeCode, true), gettype($documentTypeCode)), __LINE__);
        }
        if (is_null($documentTypeCode) || (is_array($documentTypeCode) && empty($documentTypeCode))) {
            unset($this->DocumentTypeCode);
        } else {
            $this->DocumentTypeCode = $documentTypeCode;
        }
        return $this;
    }
}
