<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentOption StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SegmentOption
 * @subpackage Structs
 */
class SegmentOption extends SegmentRef
{
    /**
     * The BookingClasses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBookingClass
     */
    public $BookingClasses;
    /**
     * The LegRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegRemarks;
    /**
     * Constructor method for SegmentOption
     * @uses SegmentOption::setBookingClasses()
     * @uses SegmentOption::setLegRemarks()
     * @param \ArrayType\ArrayOfBookingClass $bookingClasses
     * @param string $legRemarks
     */
    public function __construct(\ArrayType\ArrayOfBookingClass $bookingClasses = null, $legRemarks = null)
    {
        $this
            ->setBookingClasses($bookingClasses)
            ->setLegRemarks($legRemarks);
    }
    /**
     * Get BookingClasses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBookingClass|null
     */
    public function getBookingClasses()
    {
        return isset($this->BookingClasses) ? $this->BookingClasses : null;
    }
    /**
     * Set BookingClasses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBookingClass $bookingClasses
     * @return \StructType\SegmentOption
     */
    public function setBookingClasses(\ArrayType\ArrayOfBookingClass $bookingClasses = null)
    {
        if (is_null($bookingClasses) || (is_array($bookingClasses) && empty($bookingClasses))) {
            unset($this->BookingClasses);
        } else {
            $this->BookingClasses = $bookingClasses;
        }
        return $this;
    }
    /**
     * Get LegRemarks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegRemarks()
    {
        return isset($this->LegRemarks) ? $this->LegRemarks : null;
    }
    /**
     * Set LegRemarks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legRemarks
     * @return \StructType\SegmentOption
     */
    public function setLegRemarks($legRemarks = null)
    {
        // validation for constraint: string
        if (!is_null($legRemarks) && !is_string($legRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legRemarks, true), gettype($legRemarks)), __LINE__);
        }
        if (is_null($legRemarks) || (is_array($legRemarks) && empty($legRemarks))) {
            unset($this->LegRemarks);
        } else {
            $this->LegRemarks = $legRemarks;
        }
        return $this;
    }
}
