<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponseInfo
 * @subpackage Structs
 */
class ResponseInfo extends ApiObject
{
    /**
     * The EchoToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EchoToken;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApiError
     */
    public $Error;
    /**
     * The ProcessingMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProcessingMs;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfApiWarning
     */
    public $Warnings;
    /**
     * Constructor method for ResponseInfo
     * @uses ResponseInfo::setEchoToken()
     * @uses ResponseInfo::setError()
     * @uses ResponseInfo::setProcessingMs()
     * @uses ResponseInfo::setWarnings()
     * @param string $echoToken
     * @param \StructType\ApiError $error
     * @param int $processingMs
     * @param \ArrayType\ArrayOfApiWarning $warnings
     */
    public function __construct($echoToken = null, \StructType\ApiError $error = null, $processingMs = null, \ArrayType\ArrayOfApiWarning $warnings = null)
    {
        $this
            ->setEchoToken($echoToken)
            ->setError($error)
            ->setProcessingMs($processingMs)
            ->setWarnings($warnings);
    }
    /**
     * Get EchoToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEchoToken()
    {
        return isset($this->EchoToken) ? $this->EchoToken : null;
    }
    /**
     * Set EchoToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $echoToken
     * @return \StructType\ResponseInfo
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        if (is_null($echoToken) || (is_array($echoToken) && empty($echoToken))) {
            unset($this->EchoToken);
        } else {
            $this->EchoToken = $echoToken;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApiError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ApiError $error
     * @return \StructType\ResponseInfo
     */
    public function setError(\StructType\ApiError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get ProcessingMs value
     * @return int|null
     */
    public function getProcessingMs()
    {
        return $this->ProcessingMs;
    }
    /**
     * Set ProcessingMs value
     * @param int $processingMs
     * @return \StructType\ResponseInfo
     */
    public function setProcessingMs($processingMs = null)
    {
        // validation for constraint: int
        if (!is_null($processingMs) && !(is_int($processingMs) || ctype_digit($processingMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processingMs, true), gettype($processingMs)), __LINE__);
        }
        $this->ProcessingMs = $processingMs;
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfApiWarning|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfApiWarning $warnings
     * @return \StructType\ResponseInfo
     */
    public function setWarnings(\ArrayType\ArrayOfApiWarning $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
