<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareCheckinResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareCheckinResponse
 * @subpackage Structs
 */
class PrepareCheckinResponse extends AbstractResponse
{
    /**
     * The PrepareCheckinResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrepareCheckinResponse
     */
    public $PrepareCheckinResult;
    /**
     * The Booking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Booking
     */
    public $Booking;
    /**
     * The CheckinTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCheckinTarget
     */
    public $CheckinTargets;
    /**
     * The OptionalSpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialService
     */
    public $OptionalSpecialServices;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * Constructor method for PrepareCheckinResponse
     * @uses PrepareCheckinResponse::setPrepareCheckinResult()
     * @uses PrepareCheckinResponse::setBooking()
     * @uses PrepareCheckinResponse::setCheckinTargets()
     * @uses PrepareCheckinResponse::setOptionalSpecialServices()
     * @uses PrepareCheckinResponse::setSpecialServices()
     * @param \StructType\PrepareCheckinResponse $prepareCheckinResult
     * @param \StructType\Booking $booking
     * @param \ArrayType\ArrayOfCheckinTarget $checkinTargets
     * @param \ArrayType\ArrayOfSpecialService $optionalSpecialServices
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     */
    public function __construct(\StructType\PrepareCheckinResponse $prepareCheckinResult = null, \StructType\Booking $booking = null, \ArrayType\ArrayOfCheckinTarget $checkinTargets = null, \ArrayType\ArrayOfSpecialService $optionalSpecialServices = null, \ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this
            ->setPrepareCheckinResult($prepareCheckinResult)
            ->setBooking($booking)
            ->setCheckinTargets($checkinTargets)
            ->setOptionalSpecialServices($optionalSpecialServices)
            ->setSpecialServices($specialServices);
    }
    /**
     * Get PrepareCheckinResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrepareCheckinResponse|null
     */
    public function getPrepareCheckinResult()
    {
        return isset($this->PrepareCheckinResult) ? $this->PrepareCheckinResult : null;
    }
    /**
     * Set PrepareCheckinResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PrepareCheckinResponse $prepareCheckinResult
     * @return \StructType\PrepareCheckinResponse
     */
    public function setPrepareCheckinResult(\StructType\PrepareCheckinResponse $prepareCheckinResult = null)
    {
        if (is_null($prepareCheckinResult) || (is_array($prepareCheckinResult) && empty($prepareCheckinResult))) {
            unset($this->PrepareCheckinResult);
        } else {
            $this->PrepareCheckinResult = $prepareCheckinResult;
        }
        return $this;
    }
    /**
     * Get Booking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Booking|null
     */
    public function getBooking()
    {
        return isset($this->Booking) ? $this->Booking : null;
    }
    /**
     * Set Booking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Booking $booking
     * @return \StructType\PrepareCheckinResponse
     */
    public function setBooking(\StructType\Booking $booking = null)
    {
        if (is_null($booking) || (is_array($booking) && empty($booking))) {
            unset($this->Booking);
        } else {
            $this->Booking = $booking;
        }
        return $this;
    }
    /**
     * Get CheckinTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCheckinTarget|null
     */
    public function getCheckinTargets()
    {
        return isset($this->CheckinTargets) ? $this->CheckinTargets : null;
    }
    /**
     * Set CheckinTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCheckinTarget $checkinTargets
     * @return \StructType\PrepareCheckinResponse
     */
    public function setCheckinTargets(\ArrayType\ArrayOfCheckinTarget $checkinTargets = null)
    {
        if (is_null($checkinTargets) || (is_array($checkinTargets) && empty($checkinTargets))) {
            unset($this->CheckinTargets);
        } else {
            $this->CheckinTargets = $checkinTargets;
        }
        return $this;
    }
    /**
     * Get OptionalSpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSpecialService|null
     */
    public function getOptionalSpecialServices()
    {
        return isset($this->OptionalSpecialServices) ? $this->OptionalSpecialServices : null;
    }
    /**
     * Set OptionalSpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSpecialService $optionalSpecialServices
     * @return \StructType\PrepareCheckinResponse
     */
    public function setOptionalSpecialServices(\ArrayType\ArrayOfSpecialService $optionalSpecialServices = null)
    {
        if (is_null($optionalSpecialServices) || (is_array($optionalSpecialServices) && empty($optionalSpecialServices))) {
            unset($this->OptionalSpecialServices);
        } else {
            $this->OptionalSpecialServices = $optionalSpecialServices;
        }
        return $this;
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @return \StructType\PrepareCheckinResponse
     */
    public function setSpecialServices(\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
}
