<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PingResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PingResponse
 * @subpackage Structs
 */
class PingResponse extends AbstractResponse
{
    /**
     * The PingResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PingResponse
     */
    public $PingResult;
    /**
     * The UTC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UTC;
    /**
     * The WelcomeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WelcomeText;
    /**
     * Constructor method for PingResponse
     * @uses PingResponse::setPingResult()
     * @uses PingResponse::setUTC()
     * @uses PingResponse::setWelcomeText()
     * @param \StructType\PingResponse $pingResult
     * @param string $uTC
     * @param string $welcomeText
     */
    public function __construct(\StructType\PingResponse $pingResult = null, $uTC = null, $welcomeText = null)
    {
        $this
            ->setPingResult($pingResult)
            ->setUTC($uTC)
            ->setWelcomeText($welcomeText);
    }
    /**
     * Get PingResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PingResponse|null
     */
    public function getPingResult()
    {
        return isset($this->PingResult) ? $this->PingResult : null;
    }
    /**
     * Set PingResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PingResponse $pingResult
     * @return \StructType\PingResponse
     */
    public function setPingResult(\StructType\PingResponse $pingResult = null)
    {
        if (is_null($pingResult) || (is_array($pingResult) && empty($pingResult))) {
            unset($this->PingResult);
        } else {
            $this->PingResult = $pingResult;
        }
        return $this;
    }
    /**
     * Get UTC value
     * @return string|null
     */
    public function getUTC()
    {
        return $this->UTC;
    }
    /**
     * Set UTC value
     * @param string $uTC
     * @return \StructType\PingResponse
     */
    public function setUTC($uTC = null)
    {
        // validation for constraint: string
        if (!is_null($uTC) && !is_string($uTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uTC, true), gettype($uTC)), __LINE__);
        }
        $this->UTC = $uTC;
        return $this;
    }
    /**
     * Get WelcomeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWelcomeText()
    {
        return isset($this->WelcomeText) ? $this->WelcomeText : null;
    }
    /**
     * Set WelcomeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $welcomeText
     * @return \StructType\PingResponse
     */
    public function setWelcomeText($welcomeText = null)
    {
        // validation for constraint: string
        if (!is_null($welcomeText) && !is_string($welcomeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($welcomeText, true), gettype($welcomeText)), __LINE__);
        }
        if (is_null($welcomeText) || (is_array($welcomeText) && empty($welcomeText))) {
            unset($this->WelcomeText);
        } else {
            $this->WelcomeText = $welcomeText;
        }
        return $this;
    }
}
