<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PasswordPolicy StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PasswordPolicy
 * @subpackage Structs
 */
class PasswordPolicy extends AbstractStructBase
{
    /**
     * The IsCaseSensitive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCaseSensitive;
    /**
     * The MinDigitCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinDigitCount;
    /**
     * The MinLen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinLen;
    /**
     * The MinLetterCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinLetterCount;
    /**
     * The MinLowerLetterCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinLowerLetterCount;
    /**
     * The MinSymbolCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinSymbolCount;
    /**
     * The MinUpperLetterCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinUpperLetterCount;
    /**
     * The SymbolChars
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SymbolChars;
    /**
     * Constructor method for PasswordPolicy
     * @uses PasswordPolicy::setIsCaseSensitive()
     * @uses PasswordPolicy::setMinDigitCount()
     * @uses PasswordPolicy::setMinLen()
     * @uses PasswordPolicy::setMinLetterCount()
     * @uses PasswordPolicy::setMinLowerLetterCount()
     * @uses PasswordPolicy::setMinSymbolCount()
     * @uses PasswordPolicy::setMinUpperLetterCount()
     * @uses PasswordPolicy::setSymbolChars()
     * @param bool $isCaseSensitive
     * @param int $minDigitCount
     * @param int $minLen
     * @param int $minLetterCount
     * @param int $minLowerLetterCount
     * @param int $minSymbolCount
     * @param int $minUpperLetterCount
     * @param string $symbolChars
     */
    public function __construct($isCaseSensitive = null, $minDigitCount = null, $minLen = null, $minLetterCount = null, $minLowerLetterCount = null, $minSymbolCount = null, $minUpperLetterCount = null, $symbolChars = null)
    {
        $this
            ->setIsCaseSensitive($isCaseSensitive)
            ->setMinDigitCount($minDigitCount)
            ->setMinLen($minLen)
            ->setMinLetterCount($minLetterCount)
            ->setMinLowerLetterCount($minLowerLetterCount)
            ->setMinSymbolCount($minSymbolCount)
            ->setMinUpperLetterCount($minUpperLetterCount)
            ->setSymbolChars($symbolChars);
    }
    /**
     * Get IsCaseSensitive value
     * @return bool|null
     */
    public function getIsCaseSensitive()
    {
        return $this->IsCaseSensitive;
    }
    /**
     * Set IsCaseSensitive value
     * @param bool $isCaseSensitive
     * @return \StructType\PasswordPolicy
     */
    public function setIsCaseSensitive($isCaseSensitive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCaseSensitive) && !is_bool($isCaseSensitive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCaseSensitive, true), gettype($isCaseSensitive)), __LINE__);
        }
        $this->IsCaseSensitive = $isCaseSensitive;
        return $this;
    }
    /**
     * Get MinDigitCount value
     * @return int|null
     */
    public function getMinDigitCount()
    {
        return $this->MinDigitCount;
    }
    /**
     * Set MinDigitCount value
     * @param int $minDigitCount
     * @return \StructType\PasswordPolicy
     */
    public function setMinDigitCount($minDigitCount = null)
    {
        // validation for constraint: int
        if (!is_null($minDigitCount) && !(is_int($minDigitCount) || ctype_digit($minDigitCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minDigitCount, true), gettype($minDigitCount)), __LINE__);
        }
        $this->MinDigitCount = $minDigitCount;
        return $this;
    }
    /**
     * Get MinLen value
     * @return int|null
     */
    public function getMinLen()
    {
        return $this->MinLen;
    }
    /**
     * Set MinLen value
     * @param int $minLen
     * @return \StructType\PasswordPolicy
     */
    public function setMinLen($minLen = null)
    {
        // validation for constraint: int
        if (!is_null($minLen) && !(is_int($minLen) || ctype_digit($minLen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minLen, true), gettype($minLen)), __LINE__);
        }
        $this->MinLen = $minLen;
        return $this;
    }
    /**
     * Get MinLetterCount value
     * @return int|null
     */
    public function getMinLetterCount()
    {
        return $this->MinLetterCount;
    }
    /**
     * Set MinLetterCount value
     * @param int $minLetterCount
     * @return \StructType\PasswordPolicy
     */
    public function setMinLetterCount($minLetterCount = null)
    {
        // validation for constraint: int
        if (!is_null($minLetterCount) && !(is_int($minLetterCount) || ctype_digit($minLetterCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minLetterCount, true), gettype($minLetterCount)), __LINE__);
        }
        $this->MinLetterCount = $minLetterCount;
        return $this;
    }
    /**
     * Get MinLowerLetterCount value
     * @return int|null
     */
    public function getMinLowerLetterCount()
    {
        return $this->MinLowerLetterCount;
    }
    /**
     * Set MinLowerLetterCount value
     * @param int $minLowerLetterCount
     * @return \StructType\PasswordPolicy
     */
    public function setMinLowerLetterCount($minLowerLetterCount = null)
    {
        // validation for constraint: int
        if (!is_null($minLowerLetterCount) && !(is_int($minLowerLetterCount) || ctype_digit($minLowerLetterCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minLowerLetterCount, true), gettype($minLowerLetterCount)), __LINE__);
        }
        $this->MinLowerLetterCount = $minLowerLetterCount;
        return $this;
    }
    /**
     * Get MinSymbolCount value
     * @return int|null
     */
    public function getMinSymbolCount()
    {
        return $this->MinSymbolCount;
    }
    /**
     * Set MinSymbolCount value
     * @param int $minSymbolCount
     * @return \StructType\PasswordPolicy
     */
    public function setMinSymbolCount($minSymbolCount = null)
    {
        // validation for constraint: int
        if (!is_null($minSymbolCount) && !(is_int($minSymbolCount) || ctype_digit($minSymbolCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSymbolCount, true), gettype($minSymbolCount)), __LINE__);
        }
        $this->MinSymbolCount = $minSymbolCount;
        return $this;
    }
    /**
     * Get MinUpperLetterCount value
     * @return int|null
     */
    public function getMinUpperLetterCount()
    {
        return $this->MinUpperLetterCount;
    }
    /**
     * Set MinUpperLetterCount value
     * @param int $minUpperLetterCount
     * @return \StructType\PasswordPolicy
     */
    public function setMinUpperLetterCount($minUpperLetterCount = null)
    {
        // validation for constraint: int
        if (!is_null($minUpperLetterCount) && !(is_int($minUpperLetterCount) || ctype_digit($minUpperLetterCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minUpperLetterCount, true), gettype($minUpperLetterCount)), __LINE__);
        }
        $this->MinUpperLetterCount = $minUpperLetterCount;
        return $this;
    }
    /**
     * Get SymbolChars value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSymbolChars()
    {
        return isset($this->SymbolChars) ? $this->SymbolChars : null;
    }
    /**
     * Set SymbolChars value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $symbolChars
     * @return \StructType\PasswordPolicy
     */
    public function setSymbolChars($symbolChars = null)
    {
        // validation for constraint: string
        if (!is_null($symbolChars) && !is_string($symbolChars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($symbolChars, true), gettype($symbolChars)), __LINE__);
        }
        if (is_null($symbolChars) || (is_array($symbolChars) && empty($symbolChars))) {
            unset($this->SymbolChars);
        } else {
            $this->SymbolChars = $symbolChars;
        }
        return $this;
    }
}
