<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerSplitReference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerSplitReference
 * @subpackage Structs
 */
class PassengerSplitReference extends ApiObject
{
    /**
     * The PassengerQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassengerQuantity;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * Constructor method for PassengerSplitReference
     * @uses PassengerSplitReference::setPassengerQuantity()
     * @uses PassengerSplitReference::setRef()
     * @param int $passengerQuantity
     * @param string $ref
     */
    public function __construct($passengerQuantity = null, $ref = null)
    {
        $this
            ->setPassengerQuantity($passengerQuantity)
            ->setRef($ref);
    }
    /**
     * Get PassengerQuantity value
     * @return int|null
     */
    public function getPassengerQuantity()
    {
        return $this->PassengerQuantity;
    }
    /**
     * Set PassengerQuantity value
     * @param int $passengerQuantity
     * @return \StructType\PassengerSplitReference
     */
    public function setPassengerQuantity($passengerQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQuantity) && !(is_int($passengerQuantity) || ctype_digit($passengerQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerQuantity, true), gettype($passengerQuantity)), __LINE__);
        }
        $this->PassengerQuantity = $passengerQuantity;
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \StructType\PassengerSplitReference
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
}
