<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerNameRecord StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerNameRecord
 * @subpackage Structs
 */
class PassengerNameRecord extends ApiObject
{
    /**
     * The Passengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPassenger
     */
    public $Passengers;
    /**
     * The PnrInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PassengerNameRecordInformation
     */
    public $PnrInformation;
    /**
     * The SeatMaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatMap
     */
    public $SeatMaps;
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSegmentBooking
     */
    public $Segments;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * Constructor method for PassengerNameRecord
     * @uses PassengerNameRecord::setPassengers()
     * @uses PassengerNameRecord::setPnrInformation()
     * @uses PassengerNameRecord::setSeatMaps()
     * @uses PassengerNameRecord::setSegments()
     * @uses PassengerNameRecord::setSpecialServices()
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @param \StructType\PassengerNameRecordInformation $pnrInformation
     * @param \ArrayType\ArrayOfSeatMap $seatMaps
     * @param \ArrayType\ArrayOfSegmentBooking $segments
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     */
    public function __construct(\ArrayType\ArrayOfPassenger $passengers = null, \StructType\PassengerNameRecordInformation $pnrInformation = null, \ArrayType\ArrayOfSeatMap $seatMaps = null, \ArrayType\ArrayOfSegmentBooking $segments = null, \ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        $this
            ->setPassengers($passengers)
            ->setPnrInformation($pnrInformation)
            ->setSeatMaps($seatMaps)
            ->setSegments($segments)
            ->setSpecialServices($specialServices);
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @return \StructType\PassengerNameRecord
     */
    public function setPassengers(\ArrayType\ArrayOfPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get PnrInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PassengerNameRecordInformation|null
     */
    public function getPnrInformation()
    {
        return isset($this->PnrInformation) ? $this->PnrInformation : null;
    }
    /**
     * Set PnrInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PassengerNameRecordInformation $pnrInformation
     * @return \StructType\PassengerNameRecord
     */
    public function setPnrInformation(\StructType\PassengerNameRecordInformation $pnrInformation = null)
    {
        if (is_null($pnrInformation) || (is_array($pnrInformation) && empty($pnrInformation))) {
            unset($this->PnrInformation);
        } else {
            $this->PnrInformation = $pnrInformation;
        }
        return $this;
    }
    /**
     * Get SeatMaps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatMap|null
     */
    public function getSeatMaps()
    {
        return isset($this->SeatMaps) ? $this->SeatMaps : null;
    }
    /**
     * Set SeatMaps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatMap $seatMaps
     * @return \StructType\PassengerNameRecord
     */
    public function setSeatMaps(\ArrayType\ArrayOfSeatMap $seatMaps = null)
    {
        if (is_null($seatMaps) || (is_array($seatMaps) && empty($seatMaps))) {
            unset($this->SeatMaps);
        } else {
            $this->SeatMaps = $seatMaps;
        }
        return $this;
    }
    /**
     * Get Segments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSegmentBooking|null
     */
    public function getSegments()
    {
        return isset($this->Segments) ? $this->Segments : null;
    }
    /**
     * Set Segments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSegmentBooking $segments
     * @return \StructType\PassengerNameRecord
     */
    public function setSegments(\ArrayType\ArrayOfSegmentBooking $segments = null)
    {
        if (is_null($segments) || (is_array($segments) && empty($segments))) {
            unset($this->Segments);
        } else {
            $this->Segments = $segments;
        }
        return $this;
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @return \StructType\PassengerNameRecord
     */
    public function setSpecialServices(\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
}
