<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationTree StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OriginDestinationTree
 * @subpackage Structs
 */
class OriginDestinationTree extends ApiObject
{
    /**
     * The DestinationCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DestinationCodes;
    /**
     * The OriginCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginCode;
    /**
     * Constructor method for OriginDestinationTree
     * @uses OriginDestinationTree::setDestinationCodes()
     * @uses OriginDestinationTree::setOriginCode()
     * @param \ArrayType\ArrayOfstring $destinationCodes
     * @param string $originCode
     */
    public function __construct(\ArrayType\ArrayOfstring $destinationCodes = null, $originCode = null)
    {
        $this
            ->setDestinationCodes($destinationCodes)
            ->setOriginCode($originCode);
    }
    /**
     * Get DestinationCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDestinationCodes()
    {
        return isset($this->DestinationCodes) ? $this->DestinationCodes : null;
    }
    /**
     * Set DestinationCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $destinationCodes
     * @return \StructType\OriginDestinationTree
     */
    public function setDestinationCodes(\ArrayType\ArrayOfstring $destinationCodes = null)
    {
        if (is_null($destinationCodes) || (is_array($destinationCodes) && empty($destinationCodes))) {
            unset($this->DestinationCodes);
        } else {
            $this->DestinationCodes = $destinationCodes;
        }
        return $this;
    }
    /**
     * Get OriginCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginCode()
    {
        return isset($this->OriginCode) ? $this->OriginCode : null;
    }
    /**
     * Set OriginCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originCode
     * @return \StructType\OriginDestinationTree
     */
    public function setOriginCode($originCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCode) && !is_string($originCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCode, true), gettype($originCode)), __LINE__);
        }
        if (is_null($originCode) || (is_array($originCode) && empty($originCode))) {
            unset($this->OriginCode);
        } else {
            $this->OriginCode = $originCode;
        }
        return $this;
    }
}
