<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MiscInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MiscInfo
 * @subpackage Structs
 */
class MiscInfo extends ApiObject
{
    /**
     * The BoardingPassList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBoardingPassInfo
     */
    public $BoardingPassList;
    /**
     * The CancelInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CancelInfo
     */
    public $CancelInfo;
    /**
     * The DCSCoupons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDCSCoupon
     */
    public $DCSCoupons;
    /**
     * The ExchangeableOriginDestinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfExchangeableOriginDestination
     */
    public $ExchangeableOriginDestinations;
    /**
     * The IsPendingExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPendingExchange;
    /**
     * The PendingRefundRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RefundRequestInfo
     */
    public $PendingRefundRequest;
    /**
     * The TicketPrintHttpLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketPrintHttpLink;
    /**
     * The ContainsIssuableTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ContainsIssuableTickets;
    /**
     * The HasPendingPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasPendingPayment;
    /**
     * The HasPendingRefund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasPendingRefund;
    /**
     * Constructor method for MiscInfo
     * @uses MiscInfo::setBoardingPassList()
     * @uses MiscInfo::setCancelInfo()
     * @uses MiscInfo::setDCSCoupons()
     * @uses MiscInfo::setExchangeableOriginDestinations()
     * @uses MiscInfo::setIsPendingExchange()
     * @uses MiscInfo::setPendingRefundRequest()
     * @uses MiscInfo::setTicketPrintHttpLink()
     * @uses MiscInfo::setContainsIssuableTickets()
     * @uses MiscInfo::setHasPendingPayment()
     * @uses MiscInfo::setHasPendingRefund()
     * @param \ArrayType\ArrayOfBoardingPassInfo $boardingPassList
     * @param \StructType\CancelInfo $cancelInfo
     * @param \ArrayType\ArrayOfDCSCoupon $dCSCoupons
     * @param \ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations
     * @param bool $isPendingExchange
     * @param \StructType\RefundRequestInfo $pendingRefundRequest
     * @param string $ticketPrintHttpLink
     * @param bool $containsIssuableTickets
     * @param bool $hasPendingPayment
     * @param bool $hasPendingRefund
     */
    public function __construct(\ArrayType\ArrayOfBoardingPassInfo $boardingPassList = null, \StructType\CancelInfo $cancelInfo = null, \ArrayType\ArrayOfDCSCoupon $dCSCoupons = null, \ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations = null, $isPendingExchange = null, \StructType\RefundRequestInfo $pendingRefundRequest = null, $ticketPrintHttpLink = null, $containsIssuableTickets = null, $hasPendingPayment = null, $hasPendingRefund = null)
    {
        $this
            ->setBoardingPassList($boardingPassList)
            ->setCancelInfo($cancelInfo)
            ->setDCSCoupons($dCSCoupons)
            ->setExchangeableOriginDestinations($exchangeableOriginDestinations)
            ->setIsPendingExchange($isPendingExchange)
            ->setPendingRefundRequest($pendingRefundRequest)
            ->setTicketPrintHttpLink($ticketPrintHttpLink)
            ->setContainsIssuableTickets($containsIssuableTickets)
            ->setHasPendingPayment($hasPendingPayment)
            ->setHasPendingRefund($hasPendingRefund);
    }
    /**
     * Get BoardingPassList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBoardingPassInfo|null
     */
    public function getBoardingPassList()
    {
        return isset($this->BoardingPassList) ? $this->BoardingPassList : null;
    }
    /**
     * Set BoardingPassList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBoardingPassInfo $boardingPassList
     * @return \StructType\MiscInfo
     */
    public function setBoardingPassList(\ArrayType\ArrayOfBoardingPassInfo $boardingPassList = null)
    {
        if (is_null($boardingPassList) || (is_array($boardingPassList) && empty($boardingPassList))) {
            unset($this->BoardingPassList);
        } else {
            $this->BoardingPassList = $boardingPassList;
        }
        return $this;
    }
    /**
     * Get CancelInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CancelInfo|null
     */
    public function getCancelInfo()
    {
        return isset($this->CancelInfo) ? $this->CancelInfo : null;
    }
    /**
     * Set CancelInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CancelInfo $cancelInfo
     * @return \StructType\MiscInfo
     */
    public function setCancelInfo(\StructType\CancelInfo $cancelInfo = null)
    {
        if (is_null($cancelInfo) || (is_array($cancelInfo) && empty($cancelInfo))) {
            unset($this->CancelInfo);
        } else {
            $this->CancelInfo = $cancelInfo;
        }
        return $this;
    }
    /**
     * Get DCSCoupons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDCSCoupon|null
     */
    public function getDCSCoupons()
    {
        return isset($this->DCSCoupons) ? $this->DCSCoupons : null;
    }
    /**
     * Set DCSCoupons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDCSCoupon $dCSCoupons
     * @return \StructType\MiscInfo
     */
    public function setDCSCoupons(\ArrayType\ArrayOfDCSCoupon $dCSCoupons = null)
    {
        if (is_null($dCSCoupons) || (is_array($dCSCoupons) && empty($dCSCoupons))) {
            unset($this->DCSCoupons);
        } else {
            $this->DCSCoupons = $dCSCoupons;
        }
        return $this;
    }
    /**
     * Get ExchangeableOriginDestinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfExchangeableOriginDestination|null
     */
    public function getExchangeableOriginDestinations()
    {
        return isset($this->ExchangeableOriginDestinations) ? $this->ExchangeableOriginDestinations : null;
    }
    /**
     * Set ExchangeableOriginDestinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations
     * @return \StructType\MiscInfo
     */
    public function setExchangeableOriginDestinations(\ArrayType\ArrayOfExchangeableOriginDestination $exchangeableOriginDestinations = null)
    {
        if (is_null($exchangeableOriginDestinations) || (is_array($exchangeableOriginDestinations) && empty($exchangeableOriginDestinations))) {
            unset($this->ExchangeableOriginDestinations);
        } else {
            $this->ExchangeableOriginDestinations = $exchangeableOriginDestinations;
        }
        return $this;
    }
    /**
     * Get IsPendingExchange value
     * @return bool|null
     */
    public function getIsPendingExchange()
    {
        return $this->IsPendingExchange;
    }
    /**
     * Set IsPendingExchange value
     * @param bool $isPendingExchange
     * @return \StructType\MiscInfo
     */
    public function setIsPendingExchange($isPendingExchange = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPendingExchange) && !is_bool($isPendingExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPendingExchange, true), gettype($isPendingExchange)), __LINE__);
        }
        $this->IsPendingExchange = $isPendingExchange;
        return $this;
    }
    /**
     * Get PendingRefundRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RefundRequestInfo|null
     */
    public function getPendingRefundRequest()
    {
        return isset($this->PendingRefundRequest) ? $this->PendingRefundRequest : null;
    }
    /**
     * Set PendingRefundRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RefundRequestInfo $pendingRefundRequest
     * @return \StructType\MiscInfo
     */
    public function setPendingRefundRequest(\StructType\RefundRequestInfo $pendingRefundRequest = null)
    {
        if (is_null($pendingRefundRequest) || (is_array($pendingRefundRequest) && empty($pendingRefundRequest))) {
            unset($this->PendingRefundRequest);
        } else {
            $this->PendingRefundRequest = $pendingRefundRequest;
        }
        return $this;
    }
    /**
     * Get TicketPrintHttpLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketPrintHttpLink()
    {
        return isset($this->TicketPrintHttpLink) ? $this->TicketPrintHttpLink : null;
    }
    /**
     * Set TicketPrintHttpLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketPrintHttpLink
     * @return \StructType\MiscInfo
     */
    public function setTicketPrintHttpLink($ticketPrintHttpLink = null)
    {
        // validation for constraint: string
        if (!is_null($ticketPrintHttpLink) && !is_string($ticketPrintHttpLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketPrintHttpLink, true), gettype($ticketPrintHttpLink)), __LINE__);
        }
        if (is_null($ticketPrintHttpLink) || (is_array($ticketPrintHttpLink) && empty($ticketPrintHttpLink))) {
            unset($this->TicketPrintHttpLink);
        } else {
            $this->TicketPrintHttpLink = $ticketPrintHttpLink;
        }
        return $this;
    }
    /**
     * Get ContainsIssuableTickets value
     * @return bool|null
     */
    public function getContainsIssuableTickets()
    {
        return $this->ContainsIssuableTickets;
    }
    /**
     * Set ContainsIssuableTickets value
     * @param bool $containsIssuableTickets
     * @return \StructType\MiscInfo
     */
    public function setContainsIssuableTickets($containsIssuableTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($containsIssuableTickets) && !is_bool($containsIssuableTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($containsIssuableTickets, true), gettype($containsIssuableTickets)), __LINE__);
        }
        $this->ContainsIssuableTickets = $containsIssuableTickets;
        return $this;
    }
    /**
     * Get HasPendingPayment value
     * @return bool|null
     */
    public function getHasPendingPayment()
    {
        return $this->HasPendingPayment;
    }
    /**
     * Set HasPendingPayment value
     * @param bool $hasPendingPayment
     * @return \StructType\MiscInfo
     */
    public function setHasPendingPayment($hasPendingPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPendingPayment) && !is_bool($hasPendingPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPendingPayment, true), gettype($hasPendingPayment)), __LINE__);
        }
        $this->HasPendingPayment = $hasPendingPayment;
        return $this;
    }
    /**
     * Get HasPendingRefund value
     * @return bool|null
     */
    public function getHasPendingRefund()
    {
        return $this->HasPendingRefund;
    }
    /**
     * Set HasPendingRefund value
     * @param bool $hasPendingRefund
     * @return \StructType\MiscInfo
     */
    public function setHasPendingRefund($hasPendingRefund = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPendingRefund) && !is_bool($hasPendingRefund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPendingRefund, true), gettype($hasPendingRefund)), __LINE__);
        }
        $this->HasPendingRefund = $hasPendingRefund;
        return $this;
    }
}
