<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageRequest StructType
 * @subpackage Structs
 */
class MessageRequest extends AbstractStructBase
{
    /**
     * The Context
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageContext
     */
    public $Context;
    /**
     * The IsDiagnostics
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsDiagnostics;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * Constructor method for MessageRequest
     * @uses MessageRequest::setContext()
     * @uses MessageRequest::setIsDiagnostics()
     * @uses MessageRequest::setEchoToken()
     * @param \StructType\MessageContext $context
     * @param bool $isDiagnostics
     * @param string $echoToken
     */
    public function __construct(\StructType\MessageContext $context = null, $isDiagnostics = false, $echoToken = null)
    {
        $this
            ->setContext($context)
            ->setIsDiagnostics($isDiagnostics)
            ->setEchoToken($echoToken);
    }
    /**
     * Get Context value
     * @return \StructType\MessageContext|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param \StructType\MessageContext $context
     * @return \StructType\MessageRequest
     */
    public function setContext(\StructType\MessageContext $context = null)
    {
        $this->Context = $context;
        return $this;
    }
    /**
     * Get IsDiagnostics value
     * @return bool|null
     */
    public function getIsDiagnostics()
    {
        return $this->IsDiagnostics;
    }
    /**
     * Set IsDiagnostics value
     * @param bool $isDiagnostics
     * @return \StructType\MessageRequest
     */
    public function setIsDiagnostics($isDiagnostics = false)
    {
        // validation for constraint: boolean
        if (!is_null($isDiagnostics) && !is_bool($isDiagnostics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDiagnostics, true), gettype($isDiagnostics)), __LINE__);
        }
        $this->IsDiagnostics = $isDiagnostics;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\MessageRequest
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
}
