<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageIdentity StructType
 * @subpackage Structs
 */
class MessageIdentity extends AbstractStructBase
{
    /**
     * The IdCompany
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IdCompany;
    /**
     * The IdUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IdUser;
    /**
     * The IdPos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IdPos;
    /**
     * The IdCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IdCustomer;
    /**
     * Constructor method for MessageIdentity
     * @uses MessageIdentity::setIdCompany()
     * @uses MessageIdentity::setIdUser()
     * @uses MessageIdentity::setIdPos()
     * @uses MessageIdentity::setIdCustomer()
     * @param int $idCompany
     * @param int $idUser
     * @param int $idPos
     * @param int $idCustomer
     */
    public function __construct($idCompany = null, $idUser = null, $idPos = null, $idCustomer = null)
    {
        $this
            ->setIdCompany($idCompany)
            ->setIdUser($idUser)
            ->setIdPos($idPos)
            ->setIdCustomer($idCustomer);
    }
    /**
     * Get IdCompany value
     * @return int
     */
    public function getIdCompany()
    {
        return $this->IdCompany;
    }
    /**
     * Set IdCompany value
     * @param int $idCompany
     * @return \StructType\MessageIdentity
     */
    public function setIdCompany($idCompany = null)
    {
        // validation for constraint: int
        if (!is_null($idCompany) && !(is_int($idCompany) || ctype_digit($idCompany))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCompany, true), gettype($idCompany)), __LINE__);
        }
        $this->IdCompany = $idCompany;
        return $this;
    }
    /**
     * Get IdUser value
     * @return int
     */
    public function getIdUser()
    {
        return $this->IdUser;
    }
    /**
     * Set IdUser value
     * @param int $idUser
     * @return \StructType\MessageIdentity
     */
    public function setIdUser($idUser = null)
    {
        // validation for constraint: int
        if (!is_null($idUser) && !(is_int($idUser) || ctype_digit($idUser))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idUser, true), gettype($idUser)), __LINE__);
        }
        $this->IdUser = $idUser;
        return $this;
    }
    /**
     * Get IdPos value
     * @return int
     */
    public function getIdPos()
    {
        return $this->IdPos;
    }
    /**
     * Set IdPos value
     * @param int $idPos
     * @return \StructType\MessageIdentity
     */
    public function setIdPos($idPos = null)
    {
        // validation for constraint: int
        if (!is_null($idPos) && !(is_int($idPos) || ctype_digit($idPos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPos, true), gettype($idPos)), __LINE__);
        }
        $this->IdPos = $idPos;
        return $this;
    }
    /**
     * Get IdCustomer value
     * @return int
     */
    public function getIdCustomer()
    {
        return $this->IdCustomer;
    }
    /**
     * Set IdCustomer value
     * @param int $idCustomer
     * @return \StructType\MessageIdentity
     */
    public function setIdCustomer($idCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($idCustomer) && !(is_int($idCustomer) || ctype_digit($idCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCustomer, true), gettype($idCustomer)), __LINE__);
        }
        $this->IdCustomer = $idCustomer;
        return $this;
    }
}
