<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageContext StructType
 * @subpackage Structs
 */
class MessageContext extends AbstractStructBase
{
    /**
     * The RequestGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * - use: required
     * @var string
     */
    public $RequestGuid;
    /**
     * The Channel
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Channel;
    /**
     * The Referer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MessageReferer
     */
    public $Referer;
    /**
     * The Identities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMessageIdentity
     */
    public $Identities;
    /**
     * The RequestTraceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestTraceInfo;
    /**
     * The CultureName
     * @var string
     */
    public $CultureName;
    /**
     * The EnvName
     * @var string
     */
    public $EnvName;
    /**
     * Constructor method for MessageContext
     * @uses MessageContext::setRequestGuid()
     * @uses MessageContext::setChannel()
     * @uses MessageContext::setReferer()
     * @uses MessageContext::setIdentities()
     * @uses MessageContext::setRequestTraceInfo()
     * @uses MessageContext::setCultureName()
     * @uses MessageContext::setEnvName()
     * @param string $requestGuid
     * @param string $channel
     * @param \StructType\MessageReferer $referer
     * @param \ArrayType\ArrayOfMessageIdentity $identities
     * @param string $requestTraceInfo
     * @param string $cultureName
     * @param string $envName
     */
    public function __construct($requestGuid = null, $channel = null, \StructType\MessageReferer $referer = null, \ArrayType\ArrayOfMessageIdentity $identities = null, $requestTraceInfo = null, $cultureName = null, $envName = null)
    {
        $this
            ->setRequestGuid($requestGuid)
            ->setChannel($channel)
            ->setReferer($referer)
            ->setIdentities($identities)
            ->setRequestTraceInfo($requestTraceInfo)
            ->setCultureName($cultureName)
            ->setEnvName($envName);
    }
    /**
     * Get RequestGuid value
     * @return string
     */
    public function getRequestGuid()
    {
        return $this->RequestGuid;
    }
    /**
     * Set RequestGuid value
     * @param string $requestGuid
     * @return \StructType\MessageContext
     */
    public function setRequestGuid($requestGuid = null)
    {
        // validation for constraint: string
        if (!is_null($requestGuid) && !is_string($requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestGuid, true), gettype($requestGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestGuid, true)), __LINE__);
        }
        $this->RequestGuid = $requestGuid;
        return $this;
    }
    /**
     * Get Channel value
     * @return string
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @uses \EnumType\DistributionChannel::valueIsValid()
     * @uses \EnumType\DistributionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\MessageContext
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistributionChannel::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistributionChannel', is_array($channel) ? implode(', ', $channel) : var_export($channel, true), implode(', ', \EnumType\DistributionChannel::getValidValues())), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get Referer value
     * @return \StructType\MessageReferer|null
     */
    public function getReferer()
    {
        return $this->Referer;
    }
    /**
     * Set Referer value
     * @param \StructType\MessageReferer $referer
     * @return \StructType\MessageContext
     */
    public function setReferer(\StructType\MessageReferer $referer = null)
    {
        $this->Referer = $referer;
        return $this;
    }
    /**
     * Get Identities value
     * @return \ArrayType\ArrayOfMessageIdentity|null
     */
    public function getIdentities()
    {
        return $this->Identities;
    }
    /**
     * Set Identities value
     * @param \ArrayType\ArrayOfMessageIdentity $identities
     * @return \StructType\MessageContext
     */
    public function setIdentities(\ArrayType\ArrayOfMessageIdentity $identities = null)
    {
        $this->Identities = $identities;
        return $this;
    }
    /**
     * Get RequestTraceInfo value
     * @return string|null
     */
    public function getRequestTraceInfo()
    {
        return $this->RequestTraceInfo;
    }
    /**
     * Set RequestTraceInfo value
     * @param string $requestTraceInfo
     * @return \StructType\MessageContext
     */
    public function setRequestTraceInfo($requestTraceInfo = null)
    {
        // validation for constraint: string
        if (!is_null($requestTraceInfo) && !is_string($requestTraceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTraceInfo, true), gettype($requestTraceInfo)), __LINE__);
        }
        $this->RequestTraceInfo = $requestTraceInfo;
        return $this;
    }
    /**
     * Get CultureName value
     * @return string|null
     */
    public function getCultureName()
    {
        return $this->CultureName;
    }
    /**
     * Set CultureName value
     * @param string $cultureName
     * @return \StructType\MessageContext
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        $this->CultureName = $cultureName;
        return $this;
    }
    /**
     * Get EnvName value
     * @return string|null
     */
    public function getEnvName()
    {
        return $this->EnvName;
    }
    /**
     * Set EnvName value
     * @param string $envName
     * @return \StructType\MessageContext
     */
    public function setEnvName($envName = null)
    {
        // validation for constraint: string
        if (!is_null($envName) && !is_string($envName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envName, true), gettype($envName)), __LINE__);
        }
        $this->EnvName = $envName;
        return $this;
    }
}
