<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MCOTicket StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MCOTicket
 * @subpackage Structs
 */
class MCOTicket extends ElectronicDocument
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The ExpiryDateGMT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDateGMT;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for MCOTicket
     * @uses MCOTicket::setAmount()
     * @uses MCOTicket::setCurrency()
     * @uses MCOTicket::setExpiryDateGMT()
     * @uses MCOTicket::setStatusCode()
     * @param float $amount
     * @param string $currency
     * @param string $expiryDateGMT
     * @param string $statusCode
     */
    public function __construct($amount = null, $currency = null, $expiryDateGMT = null, $statusCode = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setExpiryDateGMT($expiryDateGMT)
            ->setStatusCode($statusCode);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\MCOTicket
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \StructType\MCOTicket
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get ExpiryDateGMT value
     * @return string|null
     */
    public function getExpiryDateGMT()
    {
        return $this->ExpiryDateGMT;
    }
    /**
     * Set ExpiryDateGMT value
     * @param string $expiryDateGMT
     * @return \StructType\MCOTicket
     */
    public function setExpiryDateGMT($expiryDateGMT = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateGMT) && !is_string($expiryDateGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateGMT, true), gettype($expiryDateGMT)), __LINE__);
        }
        $this->ExpiryDateGMT = $expiryDateGMT;
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \StructType\MCOTicket
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
}
