<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadECouponsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadECouponsRequest
 * @subpackage Structs
 */
class LoadECouponsRequest extends AbstractRequest
{
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerPrivateReference
     */
    public $CustomerReference;
    /**
     * The UsableOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsableOnly;
    /**
     * Constructor method for LoadECouponsRequest
     * @uses LoadECouponsRequest::setCustomerReference()
     * @uses LoadECouponsRequest::setUsableOnly()
     * @param \StructType\CustomerPrivateReference $customerReference
     * @param bool $usableOnly
     */
    public function __construct(\StructType\CustomerPrivateReference $customerReference = null, $usableOnly = null)
    {
        $this
            ->setCustomerReference($customerReference)
            ->setUsableOnly($usableOnly);
    }
    /**
     * Get CustomerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerPrivateReference|null
     */
    public function getCustomerReference()
    {
        return isset($this->CustomerReference) ? $this->CustomerReference : null;
    }
    /**
     * Set CustomerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerPrivateReference $customerReference
     * @return \StructType\LoadECouponsRequest
     */
    public function setCustomerReference(\StructType\CustomerPrivateReference $customerReference = null)
    {
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->CustomerReference);
        } else {
            $this->CustomerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Get UsableOnly value
     * @return bool|null
     */
    public function getUsableOnly()
    {
        return $this->UsableOnly;
    }
    /**
     * Set UsableOnly value
     * @param bool $usableOnly
     * @return \StructType\LoadECouponsRequest
     */
    public function setUsableOnly($usableOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($usableOnly) && !is_bool($usableOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usableOnly, true), gettype($usableOnly)), __LINE__);
        }
        $this->UsableOnly = $usableOnly;
        return $this;
    }
}
