<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoadBookingRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoadBookingRequest
 * @subpackage Structs
 */
class LoadBookingRequest extends AbstractRequest
{
    /**
     * The IncludeDCSCoupons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeDCSCoupons;
    /**
     * The IncludeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeDetails;
    /**
     * The IncludeFareRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeFareRules;
    /**
     * The IncludeSeatMaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSeatMaps;
    /**
     * The IncludeSegmentStops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeSegmentStops;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UniqueID
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Verification
     */
    public $Verification;
    /**
     * Constructor method for LoadBookingRequest
     * @uses LoadBookingRequest::setIncludeDCSCoupons()
     * @uses LoadBookingRequest::setIncludeDetails()
     * @uses LoadBookingRequest::setIncludeFareRules()
     * @uses LoadBookingRequest::setIncludeSeatMaps()
     * @uses LoadBookingRequest::setIncludeSegmentStops()
     * @uses LoadBookingRequest::setUniqueID()
     * @uses LoadBookingRequest::setVerification()
     * @param bool $includeDCSCoupons
     * @param bool $includeDetails
     * @param bool $includeFareRules
     * @param bool $includeSeatMaps
     * @param bool $includeSegmentStops
     * @param \StructType\UniqueID $uniqueID
     * @param \StructType\Verification $verification
     */
    public function __construct($includeDCSCoupons = null, $includeDetails = null, $includeFareRules = null, $includeSeatMaps = null, $includeSegmentStops = null, \StructType\UniqueID $uniqueID = null, \StructType\Verification $verification = null)
    {
        $this
            ->setIncludeDCSCoupons($includeDCSCoupons)
            ->setIncludeDetails($includeDetails)
            ->setIncludeFareRules($includeFareRules)
            ->setIncludeSeatMaps($includeSeatMaps)
            ->setIncludeSegmentStops($includeSegmentStops)
            ->setUniqueID($uniqueID)
            ->setVerification($verification);
    }
    /**
     * Get IncludeDCSCoupons value
     * @return bool|null
     */
    public function getIncludeDCSCoupons()
    {
        return $this->IncludeDCSCoupons;
    }
    /**
     * Set IncludeDCSCoupons value
     * @param bool $includeDCSCoupons
     * @return \StructType\LoadBookingRequest
     */
    public function setIncludeDCSCoupons($includeDCSCoupons = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDCSCoupons) && !is_bool($includeDCSCoupons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDCSCoupons, true), gettype($includeDCSCoupons)), __LINE__);
        }
        $this->IncludeDCSCoupons = $includeDCSCoupons;
        return $this;
    }
    /**
     * Get IncludeDetails value
     * @return bool|null
     */
    public function getIncludeDetails()
    {
        return $this->IncludeDetails;
    }
    /**
     * Set IncludeDetails value
     * @param bool $includeDetails
     * @return \StructType\LoadBookingRequest
     */
    public function setIncludeDetails($includeDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDetails) && !is_bool($includeDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDetails, true), gettype($includeDetails)), __LINE__);
        }
        $this->IncludeDetails = $includeDetails;
        return $this;
    }
    /**
     * Get IncludeFareRules value
     * @return bool|null
     */
    public function getIncludeFareRules()
    {
        return $this->IncludeFareRules;
    }
    /**
     * Set IncludeFareRules value
     * @param bool $includeFareRules
     * @return \StructType\LoadBookingRequest
     */
    public function setIncludeFareRules($includeFareRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFareRules) && !is_bool($includeFareRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFareRules, true), gettype($includeFareRules)), __LINE__);
        }
        $this->IncludeFareRules = $includeFareRules;
        return $this;
    }
    /**
     * Get IncludeSeatMaps value
     * @return bool|null
     */
    public function getIncludeSeatMaps()
    {
        return $this->IncludeSeatMaps;
    }
    /**
     * Set IncludeSeatMaps value
     * @param bool $includeSeatMaps
     * @return \StructType\LoadBookingRequest
     */
    public function setIncludeSeatMaps($includeSeatMaps = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSeatMaps) && !is_bool($includeSeatMaps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSeatMaps, true), gettype($includeSeatMaps)), __LINE__);
        }
        $this->IncludeSeatMaps = $includeSeatMaps;
        return $this;
    }
    /**
     * Get IncludeSegmentStops value
     * @return bool|null
     */
    public function getIncludeSegmentStops()
    {
        return $this->IncludeSegmentStops;
    }
    /**
     * Set IncludeSegmentStops value
     * @param bool $includeSegmentStops
     * @return \StructType\LoadBookingRequest
     */
    public function setIncludeSegmentStops($includeSegmentStops = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSegmentStops) && !is_bool($includeSegmentStops)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeSegmentStops, true), gettype($includeSegmentStops)), __LINE__);
        }
        $this->IncludeSegmentStops = $includeSegmentStops;
        return $this;
    }
    /**
     * Get UniqueID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UniqueID|null
     */
    public function getUniqueID()
    {
        return isset($this->UniqueID) ? $this->UniqueID : null;
    }
    /**
     * Set UniqueID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UniqueID $uniqueID
     * @return \StructType\LoadBookingRequest
     */
    public function setUniqueID(\StructType\UniqueID $uniqueID = null)
    {
        if (is_null($uniqueID) || (is_array($uniqueID) && empty($uniqueID))) {
            unset($this->UniqueID);
        } else {
            $this->UniqueID = $uniqueID;
        }
        return $this;
    }
    /**
     * Get Verification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Verification|null
     */
    public function getVerification()
    {
        return isset($this->Verification) ? $this->Verification : null;
    }
    /**
     * Set Verification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Verification $verification
     * @return \StructType\LoadBookingRequest
     */
    public function setVerification(\StructType\Verification $verification = null)
    {
        if (is_null($verification) || (is_array($verification) && empty($verification))) {
            unset($this->Verification);
        } else {
            $this->Verification = $verification;
        }
        return $this;
    }
}
