<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Itinerary
 * @subpackage Structs
 */
class Itinerary extends ApiObject
{
    /**
     * The AirOriginDestinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirOriginDestination
     */
    public $AirOriginDestinations;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * The SaleCurrencyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $SaleCurrencyAmount;
    /**
     * The RefExchangingItin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefExchangingItin;
    /**
     * The ValidatingAirlineDesignator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidatingAirlineDesignator;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setAirOriginDestinations()
     * @uses Itinerary::setRef()
     * @uses Itinerary::setSaleCurrencyAmount()
     * @uses Itinerary::setRefExchangingItin()
     * @uses Itinerary::setValidatingAirlineDesignator()
     * @param \ArrayType\ArrayOfAirOriginDestination $airOriginDestinations
     * @param string $ref
     * @param \StructType\Amount $saleCurrencyAmount
     * @param string $refExchangingItin
     * @param string $validatingAirlineDesignator
     */
    public function __construct(\ArrayType\ArrayOfAirOriginDestination $airOriginDestinations = null, $ref = null, \StructType\Amount $saleCurrencyAmount = null, $refExchangingItin = null, $validatingAirlineDesignator = null)
    {
        $this
            ->setAirOriginDestinations($airOriginDestinations)
            ->setRef($ref)
            ->setSaleCurrencyAmount($saleCurrencyAmount)
            ->setRefExchangingItin($refExchangingItin)
            ->setValidatingAirlineDesignator($validatingAirlineDesignator);
    }
    /**
     * Get AirOriginDestinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirOriginDestination|null
     */
    public function getAirOriginDestinations()
    {
        return isset($this->AirOriginDestinations) ? $this->AirOriginDestinations : null;
    }
    /**
     * Set AirOriginDestinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirOriginDestination $airOriginDestinations
     * @return \StructType\Itinerary
     */
    public function setAirOriginDestinations(\ArrayType\ArrayOfAirOriginDestination $airOriginDestinations = null)
    {
        if (is_null($airOriginDestinations) || (is_array($airOriginDestinations) && empty($airOriginDestinations))) {
            unset($this->AirOriginDestinations);
        } else {
            $this->AirOriginDestinations = $airOriginDestinations;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \StructType\Itinerary
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
    /**
     * Get SaleCurrencyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getSaleCurrencyAmount()
    {
        return isset($this->SaleCurrencyAmount) ? $this->SaleCurrencyAmount : null;
    }
    /**
     * Set SaleCurrencyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $saleCurrencyAmount
     * @return \StructType\Itinerary
     */
    public function setSaleCurrencyAmount(\StructType\Amount $saleCurrencyAmount = null)
    {
        if (is_null($saleCurrencyAmount) || (is_array($saleCurrencyAmount) && empty($saleCurrencyAmount))) {
            unset($this->SaleCurrencyAmount);
        } else {
            $this->SaleCurrencyAmount = $saleCurrencyAmount;
        }
        return $this;
    }
    /**
     * Get RefExchangingItin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefExchangingItin()
    {
        return isset($this->RefExchangingItin) ? $this->RefExchangingItin : null;
    }
    /**
     * Set RefExchangingItin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refExchangingItin
     * @return \StructType\Itinerary
     */
    public function setRefExchangingItin($refExchangingItin = null)
    {
        // validation for constraint: string
        if (!is_null($refExchangingItin) && !is_string($refExchangingItin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refExchangingItin, true), gettype($refExchangingItin)), __LINE__);
        }
        if (is_null($refExchangingItin) || (is_array($refExchangingItin) && empty($refExchangingItin))) {
            unset($this->RefExchangingItin);
        } else {
            $this->RefExchangingItin = $refExchangingItin;
        }
        return $this;
    }
    /**
     * Get ValidatingAirlineDesignator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidatingAirlineDesignator()
    {
        return isset($this->ValidatingAirlineDesignator) ? $this->ValidatingAirlineDesignator : null;
    }
    /**
     * Set ValidatingAirlineDesignator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validatingAirlineDesignator
     * @return \StructType\Itinerary
     */
    public function setValidatingAirlineDesignator($validatingAirlineDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineDesignator) && !is_string($validatingAirlineDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingAirlineDesignator, true), gettype($validatingAirlineDesignator)), __LINE__);
        }
        if (is_null($validatingAirlineDesignator) || (is_array($validatingAirlineDesignator) && empty($validatingAirlineDesignator))) {
            unset($this->ValidatingAirlineDesignator);
        } else {
            $this->ValidatingAirlineDesignator = $validatingAirlineDesignator;
        }
        return $this;
    }
}
