<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyerMileageCalculatorRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FrequentFlyerMileageCalculatorRequest
 * @subpackage Structs
 */
class FrequentFlyerMileageCalculatorRequest extends AbstractRequest
{
    /**
     * The DestinationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationCode;
    /**
     * The OriginCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginCode;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * Constructor method for FrequentFlyerMileageCalculatorRequest
     * @uses FrequentFlyerMileageCalculatorRequest::setDestinationCode()
     * @uses FrequentFlyerMileageCalculatorRequest::setOriginCode()
     * @uses FrequentFlyerMileageCalculatorRequest::setPassengerTypeCode()
     * @param string $destinationCode
     * @param string $originCode
     * @param string $passengerTypeCode
     */
    public function __construct($destinationCode = null, $originCode = null, $passengerTypeCode = null)
    {
        $this
            ->setDestinationCode($destinationCode)
            ->setOriginCode($originCode)
            ->setPassengerTypeCode($passengerTypeCode);
    }
    /**
     * Get DestinationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationCode()
    {
        return isset($this->DestinationCode) ? $this->DestinationCode : null;
    }
    /**
     * Set DestinationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationCode
     * @return \StructType\FrequentFlyerMileageCalculatorRequest
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCode, true), gettype($destinationCode)), __LINE__);
        }
        if (is_null($destinationCode) || (is_array($destinationCode) && empty($destinationCode))) {
            unset($this->DestinationCode);
        } else {
            $this->DestinationCode = $destinationCode;
        }
        return $this;
    }
    /**
     * Get OriginCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginCode()
    {
        return isset($this->OriginCode) ? $this->OriginCode : null;
    }
    /**
     * Set OriginCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originCode
     * @return \StructType\FrequentFlyerMileageCalculatorRequest
     */
    public function setOriginCode($originCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCode) && !is_string($originCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCode, true), gettype($originCode)), __LINE__);
        }
        if (is_null($originCode) || (is_array($originCode) && empty($originCode))) {
            unset($this->OriginCode);
        } else {
            $this->OriginCode = $originCode;
        }
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return isset($this->PassengerTypeCode) ? $this->PassengerTypeCode : null;
    }
    /**
     * Set PassengerTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passengerTypeCode
     * @return \StructType\FrequentFlyerMileageCalculatorRequest
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        if (is_null($passengerTypeCode) || (is_array($passengerTypeCode) && empty($passengerTypeCode))) {
            unset($this->PassengerTypeCode);
        } else {
            $this->PassengerTypeCode = $passengerTypeCode;
        }
        return $this;
    }
}
