<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyerAward StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FrequentFlyerAward
 * @subpackage Structs
 */
class FrequentFlyerAward extends ApiObject
{
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The MilesAward
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MilesAward;
    /**
     * The RefLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefLevel;
    /**
     * Constructor method for FrequentFlyerAward
     * @uses FrequentFlyerAward::setFareBasisCode()
     * @uses FrequentFlyerAward::setMilesAward()
     * @uses FrequentFlyerAward::setRefLevel()
     * @param string $fareBasisCode
     * @param int $milesAward
     * @param string $refLevel
     */
    public function __construct($fareBasisCode = null, $milesAward = null, $refLevel = null)
    {
        $this
            ->setFareBasisCode($fareBasisCode)
            ->setMilesAward($milesAward)
            ->setRefLevel($refLevel);
    }
    /**
     * Get FareBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * Set FareBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasisCode
     * @return \StructType\FrequentFlyerAward
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get MilesAward value
     * @return int|null
     */
    public function getMilesAward()
    {
        return $this->MilesAward;
    }
    /**
     * Set MilesAward value
     * @param int $milesAward
     * @return \StructType\FrequentFlyerAward
     */
    public function setMilesAward($milesAward = null)
    {
        // validation for constraint: int
        if (!is_null($milesAward) && !(is_int($milesAward) || ctype_digit($milesAward))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($milesAward, true), gettype($milesAward)), __LINE__);
        }
        $this->MilesAward = $milesAward;
        return $this;
    }
    /**
     * Get RefLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefLevel()
    {
        return isset($this->RefLevel) ? $this->RefLevel : null;
    }
    /**
     * Set RefLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refLevel
     * @return \StructType\FrequentFlyerAward
     */
    public function setRefLevel($refLevel = null)
    {
        // validation for constraint: string
        if (!is_null($refLevel) && !is_string($refLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refLevel, true), gettype($refLevel)), __LINE__);
        }
        if (is_null($refLevel) || (is_array($refLevel) && empty($refLevel))) {
            unset($this->RefLevel);
        } else {
            $this->RefLevel = $refLevel;
        }
        return $this;
    }
}
