<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyerAccount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FrequentFlyerAccount
 * @subpackage Structs
 */
class FrequentFlyerAccount extends ApiObject
{
    /**
     * The CardDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardDisplayName;
    /**
     * The FrequentFlyerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * The Operations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFrequentFlyerOperation
     */
    public $Operations;
    /**
     * The RefLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefLevel;
    /**
     * Constructor method for FrequentFlyerAccount
     * @uses FrequentFlyerAccount::setCardDisplayName()
     * @uses FrequentFlyerAccount::setFrequentFlyerNumber()
     * @uses FrequentFlyerAccount::setOperations()
     * @uses FrequentFlyerAccount::setRefLevel()
     * @param string $cardDisplayName
     * @param string $frequentFlyerNumber
     * @param \ArrayType\ArrayOfFrequentFlyerOperation $operations
     * @param string $refLevel
     */
    public function __construct($cardDisplayName = null, $frequentFlyerNumber = null, \ArrayType\ArrayOfFrequentFlyerOperation $operations = null, $refLevel = null)
    {
        $this
            ->setCardDisplayName($cardDisplayName)
            ->setFrequentFlyerNumber($frequentFlyerNumber)
            ->setOperations($operations)
            ->setRefLevel($refLevel);
    }
    /**
     * Get CardDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardDisplayName()
    {
        return isset($this->CardDisplayName) ? $this->CardDisplayName : null;
    }
    /**
     * Set CardDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardDisplayName
     * @return \StructType\FrequentFlyerAccount
     */
    public function setCardDisplayName($cardDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($cardDisplayName) && !is_string($cardDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardDisplayName, true), gettype($cardDisplayName)), __LINE__);
        }
        if (is_null($cardDisplayName) || (is_array($cardDisplayName) && empty($cardDisplayName))) {
            unset($this->CardDisplayName);
        } else {
            $this->CardDisplayName = $cardDisplayName;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return isset($this->FrequentFlyerNumber) ? $this->FrequentFlyerNumber : null;
    }
    /**
     * Set FrequentFlyerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerNumber
     * @return \StructType\FrequentFlyerAccount
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumber) && !is_string($frequentFlyerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerNumber, true), gettype($frequentFlyerNumber)), __LINE__);
        }
        if (is_null($frequentFlyerNumber) || (is_array($frequentFlyerNumber) && empty($frequentFlyerNumber))) {
            unset($this->FrequentFlyerNumber);
        } else {
            $this->FrequentFlyerNumber = $frequentFlyerNumber;
        }
        return $this;
    }
    /**
     * Get Operations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFrequentFlyerOperation|null
     */
    public function getOperations()
    {
        return isset($this->Operations) ? $this->Operations : null;
    }
    /**
     * Set Operations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFrequentFlyerOperation $operations
     * @return \StructType\FrequentFlyerAccount
     */
    public function setOperations(\ArrayType\ArrayOfFrequentFlyerOperation $operations = null)
    {
        if (is_null($operations) || (is_array($operations) && empty($operations))) {
            unset($this->Operations);
        } else {
            $this->Operations = $operations;
        }
        return $this;
    }
    /**
     * Get RefLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefLevel()
    {
        return isset($this->RefLevel) ? $this->RefLevel : null;
    }
    /**
     * Set RefLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refLevel
     * @return \StructType\FrequentFlyerAccount
     */
    public function setRefLevel($refLevel = null)
    {
        // validation for constraint: string
        if (!is_null($refLevel) && !is_string($refLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refLevel, true), gettype($refLevel)), __LINE__);
        }
        if (is_null($refLevel) || (is_array($refLevel) && empty($refLevel))) {
            unset($this->RefLevel);
        } else {
            $this->RefLevel = $refLevel;
        }
        return $this;
    }
}
