<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fop StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Fop
 * @subpackage Structs
 */
class Fop extends ApiObject
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The BankTransferInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentBankTransferInfo
     */
    public $BankTransferInfo;
    /**
     * The CheckInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentCheckInfo
     */
    public $CheckInfo;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The ECouponsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentECouponInfo
     */
    public $ECouponsInfo;
    /**
     * The MCOInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentMCOInfo
     */
    public $MCOInfo;
    /**
     * The MiscInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentMiscInfo
     */
    public $MiscInfo;
    /**
     * The RedirectInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentRedirectInfo
     */
    public $RedirectInfo;
    /**
     * The Ref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ref;
    /**
     * The RefClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefClient;
    /**
     * The SecureCardInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentSecureCardInfo
     */
    public $SecureCardInfo;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * The UnsecureCardInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormOfPaymentUnsecureCardInfo
     */
    public $UnsecureCardInfo;
    /**
     * Constructor method for Fop
     * @uses Fop::setAmount()
     * @uses Fop::setBankTransferInfo()
     * @uses Fop::setCheckInfo()
     * @uses Fop::setCode()
     * @uses Fop::setECouponsInfo()
     * @uses Fop::setMCOInfo()
     * @uses Fop::setMiscInfo()
     * @uses Fop::setRedirectInfo()
     * @uses Fop::setRef()
     * @uses Fop::setRefClient()
     * @uses Fop::setSecureCardInfo()
     * @uses Fop::setText()
     * @uses Fop::setUnsecureCardInfo()
     * @param float $amount
     * @param \StructType\FormOfPaymentBankTransferInfo $bankTransferInfo
     * @param \StructType\FormOfPaymentCheckInfo $checkInfo
     * @param string $code
     * @param \StructType\FormOfPaymentECouponInfo $eCouponsInfo
     * @param \StructType\FormOfPaymentMCOInfo $mCOInfo
     * @param \StructType\FormOfPaymentMiscInfo $miscInfo
     * @param \StructType\FormOfPaymentRedirectInfo $redirectInfo
     * @param string $ref
     * @param string $refClient
     * @param \StructType\FormOfPaymentSecureCardInfo $secureCardInfo
     * @param string $text
     * @param \StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo
     */
    public function __construct($amount = null, \StructType\FormOfPaymentBankTransferInfo $bankTransferInfo = null, \StructType\FormOfPaymentCheckInfo $checkInfo = null, $code = null, \StructType\FormOfPaymentECouponInfo $eCouponsInfo = null, \StructType\FormOfPaymentMCOInfo $mCOInfo = null, \StructType\FormOfPaymentMiscInfo $miscInfo = null, \StructType\FormOfPaymentRedirectInfo $redirectInfo = null, $ref = null, $refClient = null, \StructType\FormOfPaymentSecureCardInfo $secureCardInfo = null, $text = null, \StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo = null)
    {
        $this
            ->setAmount($amount)
            ->setBankTransferInfo($bankTransferInfo)
            ->setCheckInfo($checkInfo)
            ->setCode($code)
            ->setECouponsInfo($eCouponsInfo)
            ->setMCOInfo($mCOInfo)
            ->setMiscInfo($miscInfo)
            ->setRedirectInfo($redirectInfo)
            ->setRef($ref)
            ->setRefClient($refClient)
            ->setSecureCardInfo($secureCardInfo)
            ->setText($text)
            ->setUnsecureCardInfo($unsecureCardInfo);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Fop
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BankTransferInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentBankTransferInfo|null
     */
    public function getBankTransferInfo()
    {
        return isset($this->BankTransferInfo) ? $this->BankTransferInfo : null;
    }
    /**
     * Set BankTransferInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentBankTransferInfo $bankTransferInfo
     * @return \StructType\Fop
     */
    public function setBankTransferInfo(\StructType\FormOfPaymentBankTransferInfo $bankTransferInfo = null)
    {
        if (is_null($bankTransferInfo) || (is_array($bankTransferInfo) && empty($bankTransferInfo))) {
            unset($this->BankTransferInfo);
        } else {
            $this->BankTransferInfo = $bankTransferInfo;
        }
        return $this;
    }
    /**
     * Get CheckInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentCheckInfo|null
     */
    public function getCheckInfo()
    {
        return isset($this->CheckInfo) ? $this->CheckInfo : null;
    }
    /**
     * Set CheckInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentCheckInfo $checkInfo
     * @return \StructType\Fop
     */
    public function setCheckInfo(\StructType\FormOfPaymentCheckInfo $checkInfo = null)
    {
        if (is_null($checkInfo) || (is_array($checkInfo) && empty($checkInfo))) {
            unset($this->CheckInfo);
        } else {
            $this->CheckInfo = $checkInfo;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\Fop
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get ECouponsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentECouponInfo|null
     */
    public function getECouponsInfo()
    {
        return isset($this->ECouponsInfo) ? $this->ECouponsInfo : null;
    }
    /**
     * Set ECouponsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentECouponInfo $eCouponsInfo
     * @return \StructType\Fop
     */
    public function setECouponsInfo(\StructType\FormOfPaymentECouponInfo $eCouponsInfo = null)
    {
        if (is_null($eCouponsInfo) || (is_array($eCouponsInfo) && empty($eCouponsInfo))) {
            unset($this->ECouponsInfo);
        } else {
            $this->ECouponsInfo = $eCouponsInfo;
        }
        return $this;
    }
    /**
     * Get MCOInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentMCOInfo|null
     */
    public function getMCOInfo()
    {
        return isset($this->MCOInfo) ? $this->MCOInfo : null;
    }
    /**
     * Set MCOInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentMCOInfo $mCOInfo
     * @return \StructType\Fop
     */
    public function setMCOInfo(\StructType\FormOfPaymentMCOInfo $mCOInfo = null)
    {
        if (is_null($mCOInfo) || (is_array($mCOInfo) && empty($mCOInfo))) {
            unset($this->MCOInfo);
        } else {
            $this->MCOInfo = $mCOInfo;
        }
        return $this;
    }
    /**
     * Get MiscInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentMiscInfo|null
     */
    public function getMiscInfo()
    {
        return isset($this->MiscInfo) ? $this->MiscInfo : null;
    }
    /**
     * Set MiscInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentMiscInfo $miscInfo
     * @return \StructType\Fop
     */
    public function setMiscInfo(\StructType\FormOfPaymentMiscInfo $miscInfo = null)
    {
        if (is_null($miscInfo) || (is_array($miscInfo) && empty($miscInfo))) {
            unset($this->MiscInfo);
        } else {
            $this->MiscInfo = $miscInfo;
        }
        return $this;
    }
    /**
     * Get RedirectInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentRedirectInfo|null
     */
    public function getRedirectInfo()
    {
        return isset($this->RedirectInfo) ? $this->RedirectInfo : null;
    }
    /**
     * Set RedirectInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentRedirectInfo $redirectInfo
     * @return \StructType\Fop
     */
    public function setRedirectInfo(\StructType\FormOfPaymentRedirectInfo $redirectInfo = null)
    {
        if (is_null($redirectInfo) || (is_array($redirectInfo) && empty($redirectInfo))) {
            unset($this->RedirectInfo);
        } else {
            $this->RedirectInfo = $redirectInfo;
        }
        return $this;
    }
    /**
     * Get Ref value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRef()
    {
        return isset($this->Ref) ? $this->Ref : null;
    }
    /**
     * Set Ref value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ref
     * @return \StructType\Fop
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        if (is_null($ref) || (is_array($ref) && empty($ref))) {
            unset($this->Ref);
        } else {
            $this->Ref = $ref;
        }
        return $this;
    }
    /**
     * Get RefClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefClient()
    {
        return isset($this->RefClient) ? $this->RefClient : null;
    }
    /**
     * Set RefClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refClient
     * @return \StructType\Fop
     */
    public function setRefClient($refClient = null)
    {
        // validation for constraint: string
        if (!is_null($refClient) && !is_string($refClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refClient, true), gettype($refClient)), __LINE__);
        }
        if (is_null($refClient) || (is_array($refClient) && empty($refClient))) {
            unset($this->RefClient);
        } else {
            $this->RefClient = $refClient;
        }
        return $this;
    }
    /**
     * Get SecureCardInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentSecureCardInfo|null
     */
    public function getSecureCardInfo()
    {
        return isset($this->SecureCardInfo) ? $this->SecureCardInfo : null;
    }
    /**
     * Set SecureCardInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentSecureCardInfo $secureCardInfo
     * @return \StructType\Fop
     */
    public function setSecureCardInfo(\StructType\FormOfPaymentSecureCardInfo $secureCardInfo = null)
    {
        if (is_null($secureCardInfo) || (is_array($secureCardInfo) && empty($secureCardInfo))) {
            unset($this->SecureCardInfo);
        } else {
            $this->SecureCardInfo = $secureCardInfo;
        }
        return $this;
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\Fop
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get UnsecureCardInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormOfPaymentUnsecureCardInfo|null
     */
    public function getUnsecureCardInfo()
    {
        return isset($this->UnsecureCardInfo) ? $this->UnsecureCardInfo : null;
    }
    /**
     * Set UnsecureCardInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo
     * @return \StructType\Fop
     */
    public function setUnsecureCardInfo(\StructType\FormOfPaymentUnsecureCardInfo $unsecureCardInfo = null)
    {
        if (is_null($unsecureCardInfo) || (is_array($unsecureCardInfo) && empty($unsecureCardInfo))) {
            unset($this->UnsecureCardInfo);
        } else {
            $this->UnsecureCardInfo = $unsecureCardInfo;
        }
        return $this;
    }
}
