<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightStatusRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightStatusRequest
 * @subpackage Structs
 */
class FlightStatusRequest extends AbstractRequest
{
    /**
     * The CityPair
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CityPair
     */
    public $CityPair;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The SearchDateTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchDateTypeCode;
    /**
     * Constructor method for FlightStatusRequest
     * @uses FlightStatusRequest::setCityPair()
     * @uses FlightStatusRequest::setDate()
     * @uses FlightStatusRequest::setFlightNumber()
     * @uses FlightStatusRequest::setSearchDateTypeCode()
     * @param \StructType\CityPair $cityPair
     * @param string $date
     * @param string $flightNumber
     * @param string $searchDateTypeCode
     */
    public function __construct(\StructType\CityPair $cityPair = null, $date = null, $flightNumber = null, $searchDateTypeCode = null)
    {
        $this
            ->setCityPair($cityPair)
            ->setDate($date)
            ->setFlightNumber($flightNumber)
            ->setSearchDateTypeCode($searchDateTypeCode);
    }
    /**
     * Get CityPair value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CityPair|null
     */
    public function getCityPair()
    {
        return isset($this->CityPair) ? $this->CityPair : null;
    }
    /**
     * Set CityPair value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CityPair $cityPair
     * @return \StructType\FlightStatusRequest
     */
    public function setCityPair(\StructType\CityPair $cityPair = null)
    {
        if (is_null($cityPair) || (is_array($cityPair) && empty($cityPair))) {
            unset($this->CityPair);
        } else {
            $this->CityPair = $cityPair;
        }
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\FlightStatusRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\FlightStatusRequest
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get SearchDateTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchDateTypeCode()
    {
        return isset($this->SearchDateTypeCode) ? $this->SearchDateTypeCode : null;
    }
    /**
     * Set SearchDateTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchDateTypeCode
     * @return \StructType\FlightStatusRequest
     */
    public function setSearchDateTypeCode($searchDateTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($searchDateTypeCode) && !is_string($searchDateTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchDateTypeCode, true), gettype($searchDateTypeCode)), __LINE__);
        }
        if (is_null($searchDateTypeCode) || (is_array($searchDateTypeCode) && empty($searchDateTypeCode))) {
            unset($this->SearchDateTypeCode);
        } else {
            $this->SearchDateTypeCode = $searchDateTypeCode;
        }
        return $this;
    }
}
