<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightInfo
 * @subpackage Structs
 */
class FlightInfo extends ApiObject
{
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDate;
    /**
     * The CodeShareAgreementTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeShareAgreementTypeCode;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The DestinationAirportTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportTerminal;
    /**
     * The DurationMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DurationMinutes;
    /**
     * The EquipmentCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EquipmentCode;
    /**
     * The EquipmentText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EquipmentText;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The OperatingAirlineDesignator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingAirlineDesignator;
    /**
     * The OperatingFlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The OriginAirportTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportTerminal;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remarks;
    /**
     * The Stops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStop
     */
    public $Stops;
    /**
     * Constructor method for FlightInfo
     * @uses FlightInfo::setArrivalDate()
     * @uses FlightInfo::setCodeShareAgreementTypeCode()
     * @uses FlightInfo::setDepartureDate()
     * @uses FlightInfo::setDestinationAirportTerminal()
     * @uses FlightInfo::setDurationMinutes()
     * @uses FlightInfo::setEquipmentCode()
     * @uses FlightInfo::setEquipmentText()
     * @uses FlightInfo::setFlightNumber()
     * @uses FlightInfo::setOperatingAirlineDesignator()
     * @uses FlightInfo::setOperatingFlightNumber()
     * @uses FlightInfo::setOriginAirportTerminal()
     * @uses FlightInfo::setRemarks()
     * @uses FlightInfo::setStops()
     * @param string $arrivalDate
     * @param string $codeShareAgreementTypeCode
     * @param string $departureDate
     * @param string $destinationAirportTerminal
     * @param int $durationMinutes
     * @param string $equipmentCode
     * @param string $equipmentText
     * @param string $flightNumber
     * @param string $operatingAirlineDesignator
     * @param string $operatingFlightNumber
     * @param string $originAirportTerminal
     * @param string $remarks
     * @param \ArrayType\ArrayOfStop $stops
     */
    public function __construct($arrivalDate = null, $codeShareAgreementTypeCode = null, $departureDate = null, $destinationAirportTerminal = null, $durationMinutes = null, $equipmentCode = null, $equipmentText = null, $flightNumber = null, $operatingAirlineDesignator = null, $operatingFlightNumber = null, $originAirportTerminal = null, $remarks = null, \ArrayType\ArrayOfStop $stops = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setCodeShareAgreementTypeCode($codeShareAgreementTypeCode)
            ->setDepartureDate($departureDate)
            ->setDestinationAirportTerminal($destinationAirportTerminal)
            ->setDurationMinutes($durationMinutes)
            ->setEquipmentCode($equipmentCode)
            ->setEquipmentText($equipmentText)
            ->setFlightNumber($flightNumber)
            ->setOperatingAirlineDesignator($operatingAirlineDesignator)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setOriginAirportTerminal($originAirportTerminal)
            ->setRemarks($remarks)
            ->setStops($stops);
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\FlightInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get CodeShareAgreementTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeShareAgreementTypeCode()
    {
        return isset($this->CodeShareAgreementTypeCode) ? $this->CodeShareAgreementTypeCode : null;
    }
    /**
     * Set CodeShareAgreementTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeShareAgreementTypeCode
     * @return \StructType\FlightInfo
     */
    public function setCodeShareAgreementTypeCode($codeShareAgreementTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($codeShareAgreementTypeCode) && !is_string($codeShareAgreementTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeShareAgreementTypeCode, true), gettype($codeShareAgreementTypeCode)), __LINE__);
        }
        if (is_null($codeShareAgreementTypeCode) || (is_array($codeShareAgreementTypeCode) && empty($codeShareAgreementTypeCode))) {
            unset($this->CodeShareAgreementTypeCode);
        } else {
            $this->CodeShareAgreementTypeCode = $codeShareAgreementTypeCode;
        }
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FlightInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DestinationAirportTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportTerminal()
    {
        return isset($this->DestinationAirportTerminal) ? $this->DestinationAirportTerminal : null;
    }
    /**
     * Set DestinationAirportTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportTerminal
     * @return \StructType\FlightInfo
     */
    public function setDestinationAirportTerminal($destinationAirportTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportTerminal) && !is_string($destinationAirportTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportTerminal, true), gettype($destinationAirportTerminal)), __LINE__);
        }
        if (is_null($destinationAirportTerminal) || (is_array($destinationAirportTerminal) && empty($destinationAirportTerminal))) {
            unset($this->DestinationAirportTerminal);
        } else {
            $this->DestinationAirportTerminal = $destinationAirportTerminal;
        }
        return $this;
    }
    /**
     * Get DurationMinutes value
     * @return int|null
     */
    public function getDurationMinutes()
    {
        return $this->DurationMinutes;
    }
    /**
     * Set DurationMinutes value
     * @param int $durationMinutes
     * @return \StructType\FlightInfo
     */
    public function setDurationMinutes($durationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($durationMinutes) && !(is_int($durationMinutes) || ctype_digit($durationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationMinutes, true), gettype($durationMinutes)), __LINE__);
        }
        $this->DurationMinutes = $durationMinutes;
        return $this;
    }
    /**
     * Get EquipmentCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEquipmentCode()
    {
        return isset($this->EquipmentCode) ? $this->EquipmentCode : null;
    }
    /**
     * Set EquipmentCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $equipmentCode
     * @return \StructType\FlightInfo
     */
    public function setEquipmentCode($equipmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentCode) && !is_string($equipmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentCode, true), gettype($equipmentCode)), __LINE__);
        }
        if (is_null($equipmentCode) || (is_array($equipmentCode) && empty($equipmentCode))) {
            unset($this->EquipmentCode);
        } else {
            $this->EquipmentCode = $equipmentCode;
        }
        return $this;
    }
    /**
     * Get EquipmentText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEquipmentText()
    {
        return isset($this->EquipmentText) ? $this->EquipmentText : null;
    }
    /**
     * Set EquipmentText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $equipmentText
     * @return \StructType\FlightInfo
     */
    public function setEquipmentText($equipmentText = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentText) && !is_string($equipmentText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentText, true), gettype($equipmentText)), __LINE__);
        }
        if (is_null($equipmentText) || (is_array($equipmentText) && empty($equipmentText))) {
            unset($this->EquipmentText);
        } else {
            $this->EquipmentText = $equipmentText;
        }
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\FlightInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get OperatingAirlineDesignator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingAirlineDesignator()
    {
        return isset($this->OperatingAirlineDesignator) ? $this->OperatingAirlineDesignator : null;
    }
    /**
     * Set OperatingAirlineDesignator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingAirlineDesignator
     * @return \StructType\FlightInfo
     */
    public function setOperatingAirlineDesignator($operatingAirlineDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAirlineDesignator) && !is_string($operatingAirlineDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingAirlineDesignator, true), gettype($operatingAirlineDesignator)), __LINE__);
        }
        if (is_null($operatingAirlineDesignator) || (is_array($operatingAirlineDesignator) && empty($operatingAirlineDesignator))) {
            unset($this->OperatingAirlineDesignator);
        } else {
            $this->OperatingAirlineDesignator = $operatingAirlineDesignator;
        }
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return isset($this->OperatingFlightNumber) ? $this->OperatingFlightNumber : null;
    }
    /**
     * Set OperatingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingFlightNumber
     * @return \StructType\FlightInfo
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNumber) && !is_string($operatingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingFlightNumber, true), gettype($operatingFlightNumber)), __LINE__);
        }
        if (is_null($operatingFlightNumber) || (is_array($operatingFlightNumber) && empty($operatingFlightNumber))) {
            unset($this->OperatingFlightNumber);
        } else {
            $this->OperatingFlightNumber = $operatingFlightNumber;
        }
        return $this;
    }
    /**
     * Get OriginAirportTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportTerminal()
    {
        return isset($this->OriginAirportTerminal) ? $this->OriginAirportTerminal : null;
    }
    /**
     * Set OriginAirportTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportTerminal
     * @return \StructType\FlightInfo
     */
    public function setOriginAirportTerminal($originAirportTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportTerminal) && !is_string($originAirportTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportTerminal, true), gettype($originAirportTerminal)), __LINE__);
        }
        if (is_null($originAirportTerminal) || (is_array($originAirportTerminal) && empty($originAirportTerminal))) {
            unset($this->OriginAirportTerminal);
        } else {
            $this->OriginAirportTerminal = $originAirportTerminal;
        }
        return $this;
    }
    /**
     * Get Remarks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemarks()
    {
        return isset($this->Remarks) ? $this->Remarks : null;
    }
    /**
     * Set Remarks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remarks
     * @return \StructType\FlightInfo
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        if (is_null($remarks) || (is_array($remarks) && empty($remarks))) {
            unset($this->Remarks);
        } else {
            $this->Remarks = $remarks;
        }
        return $this;
    }
    /**
     * Get Stops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStop|null
     */
    public function getStops()
    {
        return isset($this->Stops) ? $this->Stops : null;
    }
    /**
     * Set Stops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStop $stops
     * @return \StructType\FlightInfo
     */
    public function setStops(\ArrayType\ArrayOfStop $stops = null)
    {
        if (is_null($stops) || (is_array($stops) && empty($stops))) {
            unset($this->Stops);
        } else {
            $this->Stops = $stops;
        }
        return $this;
    }
}
