<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRuleDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FareRuleDetails
 * @subpackage Structs
 */
class FareRuleDetails extends ApiObject
{
    /**
     * The AdvancePurchaseDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AdvancePurchaseDays;
    /**
     * The DayOffNightStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DayOffNightStay;
    /**
     * The ExchangePenalties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPenalty
     */
    public $ExchangePenalties;
    /**
     * The MaximumStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaximumStay;
    /**
     * The MinimumStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinimumStay;
    /**
     * The RefundPenalties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPenalty
     */
    public $RefundPenalties;
    /**
     * Constructor method for FareRuleDetails
     * @uses FareRuleDetails::setAdvancePurchaseDays()
     * @uses FareRuleDetails::setDayOffNightStay()
     * @uses FareRuleDetails::setExchangePenalties()
     * @uses FareRuleDetails::setMaximumStay()
     * @uses FareRuleDetails::setMinimumStay()
     * @uses FareRuleDetails::setRefundPenalties()
     * @param float $advancePurchaseDays
     * @param bool $dayOffNightStay
     * @param \ArrayType\ArrayOfPenalty $exchangePenalties
     * @param int $maximumStay
     * @param int $minimumStay
     * @param \ArrayType\ArrayOfPenalty $refundPenalties
     */
    public function __construct($advancePurchaseDays = null, $dayOffNightStay = null, \ArrayType\ArrayOfPenalty $exchangePenalties = null, $maximumStay = null, $minimumStay = null, \ArrayType\ArrayOfPenalty $refundPenalties = null)
    {
        $this
            ->setAdvancePurchaseDays($advancePurchaseDays)
            ->setDayOffNightStay($dayOffNightStay)
            ->setExchangePenalties($exchangePenalties)
            ->setMaximumStay($maximumStay)
            ->setMinimumStay($minimumStay)
            ->setRefundPenalties($refundPenalties);
    }
    /**
     * Get AdvancePurchaseDays value
     * @return float|null
     */
    public function getAdvancePurchaseDays()
    {
        return $this->AdvancePurchaseDays;
    }
    /**
     * Set AdvancePurchaseDays value
     * @param float $advancePurchaseDays
     * @return \StructType\FareRuleDetails
     */
    public function setAdvancePurchaseDays($advancePurchaseDays = null)
    {
        // validation for constraint: float
        if (!is_null($advancePurchaseDays) && !(is_float($advancePurchaseDays) || is_numeric($advancePurchaseDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($advancePurchaseDays, true), gettype($advancePurchaseDays)), __LINE__);
        }
        $this->AdvancePurchaseDays = $advancePurchaseDays;
        return $this;
    }
    /**
     * Get DayOffNightStay value
     * @return bool|null
     */
    public function getDayOffNightStay()
    {
        return $this->DayOffNightStay;
    }
    /**
     * Set DayOffNightStay value
     * @param bool $dayOffNightStay
     * @return \StructType\FareRuleDetails
     */
    public function setDayOffNightStay($dayOffNightStay = null)
    {
        // validation for constraint: boolean
        if (!is_null($dayOffNightStay) && !is_bool($dayOffNightStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dayOffNightStay, true), gettype($dayOffNightStay)), __LINE__);
        }
        $this->DayOffNightStay = $dayOffNightStay;
        return $this;
    }
    /**
     * Get ExchangePenalties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPenalty|null
     */
    public function getExchangePenalties()
    {
        return isset($this->ExchangePenalties) ? $this->ExchangePenalties : null;
    }
    /**
     * Set ExchangePenalties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPenalty $exchangePenalties
     * @return \StructType\FareRuleDetails
     */
    public function setExchangePenalties(\ArrayType\ArrayOfPenalty $exchangePenalties = null)
    {
        if (is_null($exchangePenalties) || (is_array($exchangePenalties) && empty($exchangePenalties))) {
            unset($this->ExchangePenalties);
        } else {
            $this->ExchangePenalties = $exchangePenalties;
        }
        return $this;
    }
    /**
     * Get MaximumStay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaximumStay()
    {
        return isset($this->MaximumStay) ? $this->MaximumStay : null;
    }
    /**
     * Set MaximumStay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maximumStay
     * @return \StructType\FareRuleDetails
     */
    public function setMaximumStay($maximumStay = null)
    {
        // validation for constraint: int
        if (!is_null($maximumStay) && !(is_int($maximumStay) || ctype_digit($maximumStay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumStay, true), gettype($maximumStay)), __LINE__);
        }
        if (is_null($maximumStay) || (is_array($maximumStay) && empty($maximumStay))) {
            unset($this->MaximumStay);
        } else {
            $this->MaximumStay = $maximumStay;
        }
        return $this;
    }
    /**
     * Get MinimumStay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinimumStay()
    {
        return isset($this->MinimumStay) ? $this->MinimumStay : null;
    }
    /**
     * Set MinimumStay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minimumStay
     * @return \StructType\FareRuleDetails
     */
    public function setMinimumStay($minimumStay = null)
    {
        // validation for constraint: int
        if (!is_null($minimumStay) && !(is_int($minimumStay) || ctype_digit($minimumStay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumStay, true), gettype($minimumStay)), __LINE__);
        }
        if (is_null($minimumStay) || (is_array($minimumStay) && empty($minimumStay))) {
            unset($this->MinimumStay);
        } else {
            $this->MinimumStay = $minimumStay;
        }
        return $this;
    }
    /**
     * Get RefundPenalties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPenalty|null
     */
    public function getRefundPenalties()
    {
        return isset($this->RefundPenalties) ? $this->RefundPenalties : null;
    }
    /**
     * Set RefundPenalties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPenalty $refundPenalties
     * @return \StructType\FareRuleDetails
     */
    public function setRefundPenalties(\ArrayType\ArrayOfPenalty $refundPenalties = null)
    {
        if (is_null($refundPenalties) || (is_array($refundPenalties) && empty($refundPenalties))) {
            unset($this->RefundPenalties);
        } else {
            $this->RefundPenalties = $refundPenalties;
        }
        return $this;
    }
}
