<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETCouponExchangedInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ETCouponExchangedInfo
 * @subpackage Structs
 */
class ETCouponExchangedInfo extends ElectronicDocument
{
    /**
     * The IataCouponNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IataCouponNumber;
    /**
     * The InvoluntaryIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoluntaryIndicator;
    /**
     * The LocalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalDateTime;
    /**
     * The SacNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SacNumber;
    /**
     * The UniversalDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UniversalDateTime;
    /**
     * Constructor method for ETCouponExchangedInfo
     * @uses ETCouponExchangedInfo::setIataCouponNumber()
     * @uses ETCouponExchangedInfo::setInvoluntaryIndicator()
     * @uses ETCouponExchangedInfo::setLocalDateTime()
     * @uses ETCouponExchangedInfo::setSacNumber()
     * @uses ETCouponExchangedInfo::setUniversalDateTime()
     * @param int $iataCouponNumber
     * @param string $involuntaryIndicator
     * @param string $localDateTime
     * @param string $sacNumber
     * @param string $universalDateTime
     */
    public function __construct($iataCouponNumber = null, $involuntaryIndicator = null, $localDateTime = null, $sacNumber = null, $universalDateTime = null)
    {
        $this
            ->setIataCouponNumber($iataCouponNumber)
            ->setInvoluntaryIndicator($involuntaryIndicator)
            ->setLocalDateTime($localDateTime)
            ->setSacNumber($sacNumber)
            ->setUniversalDateTime($universalDateTime);
    }
    /**
     * Get IataCouponNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIataCouponNumber()
    {
        return isset($this->IataCouponNumber) ? $this->IataCouponNumber : null;
    }
    /**
     * Set IataCouponNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iataCouponNumber
     * @return \StructType\ETCouponExchangedInfo
     */
    public function setIataCouponNumber($iataCouponNumber = null)
    {
        // validation for constraint: int
        if (!is_null($iataCouponNumber) && !(is_int($iataCouponNumber) || ctype_digit($iataCouponNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iataCouponNumber, true), gettype($iataCouponNumber)), __LINE__);
        }
        if (is_null($iataCouponNumber) || (is_array($iataCouponNumber) && empty($iataCouponNumber))) {
            unset($this->IataCouponNumber);
        } else {
            $this->IataCouponNumber = $iataCouponNumber;
        }
        return $this;
    }
    /**
     * Get InvoluntaryIndicator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoluntaryIndicator()
    {
        return isset($this->InvoluntaryIndicator) ? $this->InvoluntaryIndicator : null;
    }
    /**
     * Set InvoluntaryIndicator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $involuntaryIndicator
     * @return \StructType\ETCouponExchangedInfo
     */
    public function setInvoluntaryIndicator($involuntaryIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($involuntaryIndicator) && !is_string($involuntaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($involuntaryIndicator, true), gettype($involuntaryIndicator)), __LINE__);
        }
        if (is_null($involuntaryIndicator) || (is_array($involuntaryIndicator) && empty($involuntaryIndicator))) {
            unset($this->InvoluntaryIndicator);
        } else {
            $this->InvoluntaryIndicator = $involuntaryIndicator;
        }
        return $this;
    }
    /**
     * Get LocalDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalDateTime()
    {
        return isset($this->LocalDateTime) ? $this->LocalDateTime : null;
    }
    /**
     * Set LocalDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localDateTime
     * @return \StructType\ETCouponExchangedInfo
     */
    public function setLocalDateTime($localDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($localDateTime) && !is_string($localDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDateTime, true), gettype($localDateTime)), __LINE__);
        }
        if (is_null($localDateTime) || (is_array($localDateTime) && empty($localDateTime))) {
            unset($this->LocalDateTime);
        } else {
            $this->LocalDateTime = $localDateTime;
        }
        return $this;
    }
    /**
     * Get SacNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSacNumber()
    {
        return isset($this->SacNumber) ? $this->SacNumber : null;
    }
    /**
     * Set SacNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sacNumber
     * @return \StructType\ETCouponExchangedInfo
     */
    public function setSacNumber($sacNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sacNumber) && !is_string($sacNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sacNumber, true), gettype($sacNumber)), __LINE__);
        }
        if (is_null($sacNumber) || (is_array($sacNumber) && empty($sacNumber))) {
            unset($this->SacNumber);
        } else {
            $this->SacNumber = $sacNumber;
        }
        return $this;
    }
    /**
     * Get UniversalDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUniversalDateTime()
    {
        return isset($this->UniversalDateTime) ? $this->UniversalDateTime : null;
    }
    /**
     * Set UniversalDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $universalDateTime
     * @return \StructType\ETCouponExchangedInfo
     */
    public function setUniversalDateTime($universalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($universalDateTime) && !is_string($universalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($universalDateTime, true), gettype($universalDateTime)), __LINE__);
        }
        if (is_null($universalDateTime) || (is_array($universalDateTime) && empty($universalDateTime))) {
            unset($this->UniversalDateTime);
        } else {
            $this->UniversalDateTime = $universalDateTime;
        }
        return $this;
    }
}
