<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETCouponCheckin StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ETCouponCheckin
 * @subpackage Structs
 */
class ETCouponCheckin extends ApiObject
{
    /**
     * The CheckinStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckinStatusCode;
    /**
     * The CouponOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CouponOrder;
    /**
     * The NotAuthorizedDetailedReasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $NotAuthorizedDetailedReasons;
    /**
     * The NotAuthorizedReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotAuthorizedReason;
    /**
     * The SeatingMandatory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SeatingMandatory;
    /**
     * Constructor method for ETCouponCheckin
     * @uses ETCouponCheckin::setCheckinStatusCode()
     * @uses ETCouponCheckin::setCouponOrder()
     * @uses ETCouponCheckin::setNotAuthorizedDetailedReasons()
     * @uses ETCouponCheckin::setNotAuthorizedReason()
     * @uses ETCouponCheckin::setSeatingMandatory()
     * @param string $checkinStatusCode
     * @param int $couponOrder
     * @param \ArrayType\ArrayOfstring $notAuthorizedDetailedReasons
     * @param string $notAuthorizedReason
     * @param bool $seatingMandatory
     */
    public function __construct($checkinStatusCode = null, $couponOrder = null, \ArrayType\ArrayOfstring $notAuthorizedDetailedReasons = null, $notAuthorizedReason = null, $seatingMandatory = null)
    {
        $this
            ->setCheckinStatusCode($checkinStatusCode)
            ->setCouponOrder($couponOrder)
            ->setNotAuthorizedDetailedReasons($notAuthorizedDetailedReasons)
            ->setNotAuthorizedReason($notAuthorizedReason)
            ->setSeatingMandatory($seatingMandatory);
    }
    /**
     * Get CheckinStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckinStatusCode()
    {
        return isset($this->CheckinStatusCode) ? $this->CheckinStatusCode : null;
    }
    /**
     * Set CheckinStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkinStatusCode
     * @return \StructType\ETCouponCheckin
     */
    public function setCheckinStatusCode($checkinStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($checkinStatusCode) && !is_string($checkinStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkinStatusCode, true), gettype($checkinStatusCode)), __LINE__);
        }
        if (is_null($checkinStatusCode) || (is_array($checkinStatusCode) && empty($checkinStatusCode))) {
            unset($this->CheckinStatusCode);
        } else {
            $this->CheckinStatusCode = $checkinStatusCode;
        }
        return $this;
    }
    /**
     * Get CouponOrder value
     * @return int|null
     */
    public function getCouponOrder()
    {
        return $this->CouponOrder;
    }
    /**
     * Set CouponOrder value
     * @param int $couponOrder
     * @return \StructType\ETCouponCheckin
     */
    public function setCouponOrder($couponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($couponOrder) && !(is_int($couponOrder) || ctype_digit($couponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponOrder, true), gettype($couponOrder)), __LINE__);
        }
        $this->CouponOrder = $couponOrder;
        return $this;
    }
    /**
     * Get NotAuthorizedDetailedReasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getNotAuthorizedDetailedReasons()
    {
        return isset($this->NotAuthorizedDetailedReasons) ? $this->NotAuthorizedDetailedReasons : null;
    }
    /**
     * Set NotAuthorizedDetailedReasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $notAuthorizedDetailedReasons
     * @return \StructType\ETCouponCheckin
     */
    public function setNotAuthorizedDetailedReasons(\ArrayType\ArrayOfstring $notAuthorizedDetailedReasons = null)
    {
        if (is_null($notAuthorizedDetailedReasons) || (is_array($notAuthorizedDetailedReasons) && empty($notAuthorizedDetailedReasons))) {
            unset($this->NotAuthorizedDetailedReasons);
        } else {
            $this->NotAuthorizedDetailedReasons = $notAuthorizedDetailedReasons;
        }
        return $this;
    }
    /**
     * Get NotAuthorizedReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotAuthorizedReason()
    {
        return isset($this->NotAuthorizedReason) ? $this->NotAuthorizedReason : null;
    }
    /**
     * Set NotAuthorizedReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notAuthorizedReason
     * @return \StructType\ETCouponCheckin
     */
    public function setNotAuthorizedReason($notAuthorizedReason = null)
    {
        // validation for constraint: string
        if (!is_null($notAuthorizedReason) && !is_string($notAuthorizedReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notAuthorizedReason, true), gettype($notAuthorizedReason)), __LINE__);
        }
        if (is_null($notAuthorizedReason) || (is_array($notAuthorizedReason) && empty($notAuthorizedReason))) {
            unset($this->NotAuthorizedReason);
        } else {
            $this->NotAuthorizedReason = $notAuthorizedReason;
        }
        return $this;
    }
    /**
     * Get SeatingMandatory value
     * @return bool|null
     */
    public function getSeatingMandatory()
    {
        return $this->SeatingMandatory;
    }
    /**
     * Set SeatingMandatory value
     * @param bool $seatingMandatory
     * @return \StructType\ETCouponCheckin
     */
    public function setSeatingMandatory($seatingMandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($seatingMandatory) && !is_bool($seatingMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($seatingMandatory, true), gettype($seatingMandatory)), __LINE__);
        }
        $this->SeatingMandatory = $seatingMandatory;
        return $this;
    }
}
