<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMDTicket StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EMDTicket
 * @subpackage Structs
 */
class EMDTicket extends AbstractTicket
{
    /**
     * The IataInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EMDTicketIataInfo
     */
    public $IataInformation;
    /**
     * The LinkedCouponOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LinkedCouponOrder;
    /**
     * The LinkedETTicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkedETTicketNumber;
    /**
     * The RefEMDTicketFare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefEMDTicketFare;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for EMDTicket
     * @uses EMDTicket::setIataInformation()
     * @uses EMDTicket::setLinkedCouponOrder()
     * @uses EMDTicket::setLinkedETTicketNumber()
     * @uses EMDTicket::setRefEMDTicketFare()
     * @uses EMDTicket::setStatusCode()
     * @param \StructType\EMDTicketIataInfo $iataInformation
     * @param int $linkedCouponOrder
     * @param string $linkedETTicketNumber
     * @param string $refEMDTicketFare
     * @param string $statusCode
     */
    public function __construct(\StructType\EMDTicketIataInfo $iataInformation = null, $linkedCouponOrder = null, $linkedETTicketNumber = null, $refEMDTicketFare = null, $statusCode = null)
    {
        $this
            ->setIataInformation($iataInformation)
            ->setLinkedCouponOrder($linkedCouponOrder)
            ->setLinkedETTicketNumber($linkedETTicketNumber)
            ->setRefEMDTicketFare($refEMDTicketFare)
            ->setStatusCode($statusCode);
    }
    /**
     * Get IataInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EMDTicketIataInfo|null
     */
    public function getIataInformation()
    {
        return isset($this->IataInformation) ? $this->IataInformation : null;
    }
    /**
     * Set IataInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EMDTicketIataInfo $iataInformation
     * @return \StructType\EMDTicket
     */
    public function setIataInformation(\StructType\EMDTicketIataInfo $iataInformation = null)
    {
        if (is_null($iataInformation) || (is_array($iataInformation) && empty($iataInformation))) {
            unset($this->IataInformation);
        } else {
            $this->IataInformation = $iataInformation;
        }
        return $this;
    }
    /**
     * Get LinkedCouponOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkedCouponOrder()
    {
        return isset($this->LinkedCouponOrder) ? $this->LinkedCouponOrder : null;
    }
    /**
     * Set LinkedCouponOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkedCouponOrder
     * @return \StructType\EMDTicket
     */
    public function setLinkedCouponOrder($linkedCouponOrder = null)
    {
        // validation for constraint: int
        if (!is_null($linkedCouponOrder) && !(is_int($linkedCouponOrder) || ctype_digit($linkedCouponOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkedCouponOrder, true), gettype($linkedCouponOrder)), __LINE__);
        }
        if (is_null($linkedCouponOrder) || (is_array($linkedCouponOrder) && empty($linkedCouponOrder))) {
            unset($this->LinkedCouponOrder);
        } else {
            $this->LinkedCouponOrder = $linkedCouponOrder;
        }
        return $this;
    }
    /**
     * Get LinkedETTicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkedETTicketNumber()
    {
        return isset($this->LinkedETTicketNumber) ? $this->LinkedETTicketNumber : null;
    }
    /**
     * Set LinkedETTicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkedETTicketNumber
     * @return \StructType\EMDTicket
     */
    public function setLinkedETTicketNumber($linkedETTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($linkedETTicketNumber) && !is_string($linkedETTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedETTicketNumber, true), gettype($linkedETTicketNumber)), __LINE__);
        }
        if (is_null($linkedETTicketNumber) || (is_array($linkedETTicketNumber) && empty($linkedETTicketNumber))) {
            unset($this->LinkedETTicketNumber);
        } else {
            $this->LinkedETTicketNumber = $linkedETTicketNumber;
        }
        return $this;
    }
    /**
     * Get RefEMDTicketFare value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefEMDTicketFare()
    {
        return isset($this->RefEMDTicketFare) ? $this->RefEMDTicketFare : null;
    }
    /**
     * Set RefEMDTicketFare value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refEMDTicketFare
     * @return \StructType\EMDTicket
     */
    public function setRefEMDTicketFare($refEMDTicketFare = null)
    {
        // validation for constraint: string
        if (!is_null($refEMDTicketFare) && !is_string($refEMDTicketFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refEMDTicketFare, true), gettype($refEMDTicketFare)), __LINE__);
        }
        if (is_null($refEMDTicketFare) || (is_array($refEMDTicketFare) && empty($refEMDTicketFare))) {
            unset($this->RefEMDTicketFare);
        } else {
            $this->RefEMDTicketFare = $refEMDTicketFare;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \StructType\EMDTicket
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
}
