<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ECouponBookCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ECouponBookCode
 * @subpackage Structs
 */
class ECouponBookCode extends ApiObject
{
    /**
     * The BookCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookCode;
    /**
     * Constructor method for ECouponBookCode
     * @uses ECouponBookCode::setBookCode()
     * @param string $bookCode
     */
    public function __construct($bookCode = null)
    {
        $this
            ->setBookCode($bookCode);
    }
    /**
     * Get BookCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookCode()
    {
        return isset($this->BookCode) ? $this->BookCode : null;
    }
    /**
     * Set BookCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookCode
     * @return \StructType\ECouponBookCode
     */
    public function setBookCode($bookCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookCode) && !is_string($bookCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookCode, true), gettype($bookCode)), __LINE__);
        }
        if (is_null($bookCode) || (is_array($bookCode) && empty($bookCode))) {
            unset($this->BookCode);
        } else {
            $this->BookCode = $bookCode;
        }
        return $this;
    }
}
