<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DATIssuanceInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DATIssuanceInfo
 * @subpackage Structs
 */
class DATIssuanceInfo extends ApiObject
{
    /**
     * The NotValidAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotValidAfter;
    /**
     * The NotValidBefore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotValidBefore;
    /**
     * Constructor method for DATIssuanceInfo
     * @uses DATIssuanceInfo::setNotValidAfter()
     * @uses DATIssuanceInfo::setNotValidBefore()
     * @param string $notValidAfter
     * @param string $notValidBefore
     */
    public function __construct($notValidAfter = null, $notValidBefore = null)
    {
        $this
            ->setNotValidAfter($notValidAfter)
            ->setNotValidBefore($notValidBefore);
    }
    /**
     * Get NotValidAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotValidAfter()
    {
        return isset($this->NotValidAfter) ? $this->NotValidAfter : null;
    }
    /**
     * Set NotValidAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notValidAfter
     * @return \StructType\DATIssuanceInfo
     */
    public function setNotValidAfter($notValidAfter = null)
    {
        // validation for constraint: string
        if (!is_null($notValidAfter) && !is_string($notValidAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notValidAfter, true), gettype($notValidAfter)), __LINE__);
        }
        if (is_null($notValidAfter) || (is_array($notValidAfter) && empty($notValidAfter))) {
            unset($this->NotValidAfter);
        } else {
            $this->NotValidAfter = $notValidAfter;
        }
        return $this;
    }
    /**
     * Get NotValidBefore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotValidBefore()
    {
        return isset($this->NotValidBefore) ? $this->NotValidBefore : null;
    }
    /**
     * Set NotValidBefore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notValidBefore
     * @return \StructType\DATIssuanceInfo
     */
    public function setNotValidBefore($notValidBefore = null)
    {
        // validation for constraint: string
        if (!is_null($notValidBefore) && !is_string($notValidBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notValidBefore, true), gettype($notValidBefore)), __LINE__);
        }
        if (is_null($notValidBefore) || (is_array($notValidBefore) && empty($notValidBefore))) {
            unset($this->NotValidBefore);
        } else {
            $this->NotValidBefore = $notValidBefore;
        }
        return $this;
    }
}
