<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPasswordPolicy StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerPasswordPolicy
 * @subpackage Structs
 */
class CustomerPasswordPolicy extends AbstractStructBase
{
    /**
     * The CustomerTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerTypeCode;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PasswordPolicy
     */
    public $Policy;
    /**
     * Constructor method for CustomerPasswordPolicy
     * @uses CustomerPasswordPolicy::setCustomerTypeCode()
     * @uses CustomerPasswordPolicy::setPolicy()
     * @param string $customerTypeCode
     * @param \StructType\PasswordPolicy $policy
     */
    public function __construct($customerTypeCode = null, \StructType\PasswordPolicy $policy = null)
    {
        $this
            ->setCustomerTypeCode($customerTypeCode)
            ->setPolicy($policy);
    }
    /**
     * Get CustomerTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerTypeCode()
    {
        return isset($this->CustomerTypeCode) ? $this->CustomerTypeCode : null;
    }
    /**
     * Set CustomerTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerTypeCode
     * @return \StructType\CustomerPasswordPolicy
     */
    public function setCustomerTypeCode($customerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerTypeCode) && !is_string($customerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTypeCode, true), gettype($customerTypeCode)), __LINE__);
        }
        if (is_null($customerTypeCode) || (is_array($customerTypeCode) && empty($customerTypeCode))) {
            unset($this->CustomerTypeCode);
        } else {
            $this->CustomerTypeCode = $customerTypeCode;
        }
        return $this;
    }
    /**
     * Get Policy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PasswordPolicy|null
     */
    public function getPolicy()
    {
        return isset($this->Policy) ? $this->Policy : null;
    }
    /**
     * Set Policy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PasswordPolicy $policy
     * @return \StructType\CustomerPasswordPolicy
     */
    public function setPolicy(\StructType\PasswordPolicy $policy = null)
    {
        if (is_null($policy) || (is_array($policy) && empty($policy))) {
            unset($this->Policy);
        } else {
            $this->Policy = $policy;
        }
        return $this;
    }
}
