<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyRates StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CurrencyRates
 * @subpackage Structs
 */
class CurrencyRates extends ApiObject
{
    /**
     * The FareToBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FareToBase;
    /**
     * The FareToNUC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FareToNUC;
    /**
     * The FareToSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FareToSale;
    /**
     * The NUCToBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NUCToBase;
    /**
     * The SaleToBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SaleToBase;
    /**
     * The SaleToNUC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SaleToNUC;
    /**
     * Constructor method for CurrencyRates
     * @uses CurrencyRates::setFareToBase()
     * @uses CurrencyRates::setFareToNUC()
     * @uses CurrencyRates::setFareToSale()
     * @uses CurrencyRates::setNUCToBase()
     * @uses CurrencyRates::setSaleToBase()
     * @uses CurrencyRates::setSaleToNUC()
     * @param float $fareToBase
     * @param float $fareToNUC
     * @param float $fareToSale
     * @param float $nUCToBase
     * @param float $saleToBase
     * @param float $saleToNUC
     */
    public function __construct($fareToBase = null, $fareToNUC = null, $fareToSale = null, $nUCToBase = null, $saleToBase = null, $saleToNUC = null)
    {
        $this
            ->setFareToBase($fareToBase)
            ->setFareToNUC($fareToNUC)
            ->setFareToSale($fareToSale)
            ->setNUCToBase($nUCToBase)
            ->setSaleToBase($saleToBase)
            ->setSaleToNUC($saleToNUC);
    }
    /**
     * Get FareToBase value
     * @return float|null
     */
    public function getFareToBase()
    {
        return $this->FareToBase;
    }
    /**
     * Set FareToBase value
     * @param float $fareToBase
     * @return \StructType\CurrencyRates
     */
    public function setFareToBase($fareToBase = null)
    {
        // validation for constraint: float
        if (!is_null($fareToBase) && !(is_float($fareToBase) || is_numeric($fareToBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareToBase, true), gettype($fareToBase)), __LINE__);
        }
        $this->FareToBase = $fareToBase;
        return $this;
    }
    /**
     * Get FareToNUC value
     * @return float|null
     */
    public function getFareToNUC()
    {
        return $this->FareToNUC;
    }
    /**
     * Set FareToNUC value
     * @param float $fareToNUC
     * @return \StructType\CurrencyRates
     */
    public function setFareToNUC($fareToNUC = null)
    {
        // validation for constraint: float
        if (!is_null($fareToNUC) && !(is_float($fareToNUC) || is_numeric($fareToNUC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareToNUC, true), gettype($fareToNUC)), __LINE__);
        }
        $this->FareToNUC = $fareToNUC;
        return $this;
    }
    /**
     * Get FareToSale value
     * @return float|null
     */
    public function getFareToSale()
    {
        return $this->FareToSale;
    }
    /**
     * Set FareToSale value
     * @param float $fareToSale
     * @return \StructType\CurrencyRates
     */
    public function setFareToSale($fareToSale = null)
    {
        // validation for constraint: float
        if (!is_null($fareToSale) && !(is_float($fareToSale) || is_numeric($fareToSale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareToSale, true), gettype($fareToSale)), __LINE__);
        }
        $this->FareToSale = $fareToSale;
        return $this;
    }
    /**
     * Get NUCToBase value
     * @return float|null
     */
    public function getNUCToBase()
    {
        return $this->NUCToBase;
    }
    /**
     * Set NUCToBase value
     * @param float $nUCToBase
     * @return \StructType\CurrencyRates
     */
    public function setNUCToBase($nUCToBase = null)
    {
        // validation for constraint: float
        if (!is_null($nUCToBase) && !(is_float($nUCToBase) || is_numeric($nUCToBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nUCToBase, true), gettype($nUCToBase)), __LINE__);
        }
        $this->NUCToBase = $nUCToBase;
        return $this;
    }
    /**
     * Get SaleToBase value
     * @return float|null
     */
    public function getSaleToBase()
    {
        return $this->SaleToBase;
    }
    /**
     * Set SaleToBase value
     * @param float $saleToBase
     * @return \StructType\CurrencyRates
     */
    public function setSaleToBase($saleToBase = null)
    {
        // validation for constraint: float
        if (!is_null($saleToBase) && !(is_float($saleToBase) || is_numeric($saleToBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleToBase, true), gettype($saleToBase)), __LINE__);
        }
        $this->SaleToBase = $saleToBase;
        return $this;
    }
    /**
     * Get SaleToNUC value
     * @return float|null
     */
    public function getSaleToNUC()
    {
        return $this->SaleToNUC;
    }
    /**
     * Set SaleToNUC value
     * @param float $saleToNUC
     * @return \StructType\CurrencyRates
     */
    public function setSaleToNUC($saleToNUC = null)
    {
        // validation for constraint: float
        if (!is_null($saleToNUC) && !(is_float($saleToNUC) || is_numeric($saleToNUC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleToNUC, true), gettype($saleToNUC)), __LINE__);
        }
        $this->SaleToNUC = $saleToNUC;
        return $this;
    }
}
