<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateTicketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateTicketRequest
 * @subpackage Structs
 */
class CreateTicketRequest extends AbstractRequest
{
    /**
     * The Fops
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFop
     */
    public $Fops;
    /**
     * The PaymentModeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentModeCode;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UniqueID
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Verification
     */
    public $Verification;
    /**
     * Constructor method for CreateTicketRequest
     * @uses CreateTicketRequest::setFops()
     * @uses CreateTicketRequest::setPaymentModeCode()
     * @uses CreateTicketRequest::setUniqueID()
     * @uses CreateTicketRequest::setVerification()
     * @param \ArrayType\ArrayOfFop $fops
     * @param string $paymentModeCode
     * @param \StructType\UniqueID $uniqueID
     * @param \StructType\Verification $verification
     */
    public function __construct(\ArrayType\ArrayOfFop $fops = null, $paymentModeCode = null, \StructType\UniqueID $uniqueID = null, \StructType\Verification $verification = null)
    {
        $this
            ->setFops($fops)
            ->setPaymentModeCode($paymentModeCode)
            ->setUniqueID($uniqueID)
            ->setVerification($verification);
    }
    /**
     * Get Fops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFop|null
     */
    public function getFops()
    {
        return isset($this->Fops) ? $this->Fops : null;
    }
    /**
     * Set Fops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFop $fops
     * @return \StructType\CreateTicketRequest
     */
    public function setFops(\ArrayType\ArrayOfFop $fops = null)
    {
        if (is_null($fops) || (is_array($fops) && empty($fops))) {
            unset($this->Fops);
        } else {
            $this->Fops = $fops;
        }
        return $this;
    }
    /**
     * Get PaymentModeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentModeCode()
    {
        return isset($this->PaymentModeCode) ? $this->PaymentModeCode : null;
    }
    /**
     * Set PaymentModeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentModeCode
     * @return \StructType\CreateTicketRequest
     */
    public function setPaymentModeCode($paymentModeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentModeCode) && !is_string($paymentModeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentModeCode, true), gettype($paymentModeCode)), __LINE__);
        }
        if (is_null($paymentModeCode) || (is_array($paymentModeCode) && empty($paymentModeCode))) {
            unset($this->PaymentModeCode);
        } else {
            $this->PaymentModeCode = $paymentModeCode;
        }
        return $this;
    }
    /**
     * Get UniqueID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UniqueID|null
     */
    public function getUniqueID()
    {
        return isset($this->UniqueID) ? $this->UniqueID : null;
    }
    /**
     * Set UniqueID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UniqueID $uniqueID
     * @return \StructType\CreateTicketRequest
     */
    public function setUniqueID(\StructType\UniqueID $uniqueID = null)
    {
        if (is_null($uniqueID) || (is_array($uniqueID) && empty($uniqueID))) {
            unset($this->UniqueID);
        } else {
            $this->UniqueID = $uniqueID;
        }
        return $this;
    }
    /**
     * Get Verification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Verification|null
     */
    public function getVerification()
    {
        return isset($this->Verification) ? $this->Verification : null;
    }
    /**
     * Set Verification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Verification $verification
     * @return \StructType\CreateTicketRequest
     */
    public function setVerification(\StructType\Verification $verification = null)
    {
        if (is_null($verification) || (is_array($verification) && empty($verification))) {
            unset($this->Verification);
        } else {
            $this->Verification = $verification;
        }
        return $this;
    }
}
