<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBookingRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateBookingRequest
 * @subpackage Structs
 */
class CreateBookingRequest extends AbstractRequest
{
    /**
     * The DeferredIssuance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DeferredIssuance;
    /**
     * The ECouponBookCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfECouponBookCode
     */
    public $ECouponBookCodes;
    /**
     * The FareInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FareInfoEMD
     */
    public $FareInfo;
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OfferIn
     */
    public $Offer;
    /**
     * The Passengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPassenger
     */
    public $Passengers;
    /**
     * The PromoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoCode;
    /**
     * The RefCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefCustomer;
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSegmentBooking
     */
    public $Segments;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSpecialService
     */
    public $SpecialServices;
    /**
     * The WebClassesCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $WebClassesCodes;
    /**
     * Constructor method for CreateBookingRequest
     * @uses CreateBookingRequest::setDeferredIssuance()
     * @uses CreateBookingRequest::setECouponBookCodes()
     * @uses CreateBookingRequest::setFareInfo()
     * @uses CreateBookingRequest::setOffer()
     * @uses CreateBookingRequest::setPassengers()
     * @uses CreateBookingRequest::setPromoCode()
     * @uses CreateBookingRequest::setRefCustomer()
     * @uses CreateBookingRequest::setSegments()
     * @uses CreateBookingRequest::setSpecialServices()
     * @uses CreateBookingRequest::setWebClassesCodes()
     * @param bool $deferredIssuance
     * @param \ArrayType\ArrayOfECouponBookCode $eCouponBookCodes
     * @param \StructType\FareInfoEMD $fareInfo
     * @param \StructType\OfferIn $offer
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @param string $promoCode
     * @param string $refCustomer
     * @param \ArrayType\ArrayOfSegmentBooking $segments
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @param \ArrayType\ArrayOfstring $webClassesCodes
     */
    public function __construct($deferredIssuance = null, \ArrayType\ArrayOfECouponBookCode $eCouponBookCodes = null, \StructType\FareInfoEMD $fareInfo = null, \StructType\OfferIn $offer = null, \ArrayType\ArrayOfPassenger $passengers = null, $promoCode = null, $refCustomer = null, \ArrayType\ArrayOfSegmentBooking $segments = null, \ArrayType\ArrayOfSpecialService $specialServices = null, \ArrayType\ArrayOfstring $webClassesCodes = null)
    {
        $this
            ->setDeferredIssuance($deferredIssuance)
            ->setECouponBookCodes($eCouponBookCodes)
            ->setFareInfo($fareInfo)
            ->setOffer($offer)
            ->setPassengers($passengers)
            ->setPromoCode($promoCode)
            ->setRefCustomer($refCustomer)
            ->setSegments($segments)
            ->setSpecialServices($specialServices)
            ->setWebClassesCodes($webClassesCodes);
    }
    /**
     * Get DeferredIssuance value
     * @return bool|null
     */
    public function getDeferredIssuance()
    {
        return $this->DeferredIssuance;
    }
    /**
     * Set DeferredIssuance value
     * @param bool $deferredIssuance
     * @return \StructType\CreateBookingRequest
     */
    public function setDeferredIssuance($deferredIssuance = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferredIssuance) && !is_bool($deferredIssuance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferredIssuance, true), gettype($deferredIssuance)), __LINE__);
        }
        $this->DeferredIssuance = $deferredIssuance;
        return $this;
    }
    /**
     * Get ECouponBookCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfECouponBookCode|null
     */
    public function getECouponBookCodes()
    {
        return isset($this->ECouponBookCodes) ? $this->ECouponBookCodes : null;
    }
    /**
     * Set ECouponBookCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfECouponBookCode $eCouponBookCodes
     * @return \StructType\CreateBookingRequest
     */
    public function setECouponBookCodes(\ArrayType\ArrayOfECouponBookCode $eCouponBookCodes = null)
    {
        if (is_null($eCouponBookCodes) || (is_array($eCouponBookCodes) && empty($eCouponBookCodes))) {
            unset($this->ECouponBookCodes);
        } else {
            $this->ECouponBookCodes = $eCouponBookCodes;
        }
        return $this;
    }
    /**
     * Get FareInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FareInfoEMD|null
     */
    public function getFareInfo()
    {
        return isset($this->FareInfo) ? $this->FareInfo : null;
    }
    /**
     * Set FareInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FareInfoEMD $fareInfo
     * @return \StructType\CreateBookingRequest
     */
    public function setFareInfo(\StructType\FareInfoEMD $fareInfo = null)
    {
        if (is_null($fareInfo) || (is_array($fareInfo) && empty($fareInfo))) {
            unset($this->FareInfo);
        } else {
            $this->FareInfo = $fareInfo;
        }
        return $this;
    }
    /**
     * Get Offer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OfferIn|null
     */
    public function getOffer()
    {
        return isset($this->Offer) ? $this->Offer : null;
    }
    /**
     * Set Offer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OfferIn $offer
     * @return \StructType\CreateBookingRequest
     */
    public function setOffer(\StructType\OfferIn $offer = null)
    {
        if (is_null($offer) || (is_array($offer) && empty($offer))) {
            unset($this->Offer);
        } else {
            $this->Offer = $offer;
        }
        return $this;
    }
    /**
     * Get Passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPassenger|null
     */
    public function getPassengers()
    {
        return isset($this->Passengers) ? $this->Passengers : null;
    }
    /**
     * Set Passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPassenger $passengers
     * @return \StructType\CreateBookingRequest
     */
    public function setPassengers(\ArrayType\ArrayOfPassenger $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->Passengers);
        } else {
            $this->Passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get PromoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoCode()
    {
        return isset($this->PromoCode) ? $this->PromoCode : null;
    }
    /**
     * Set PromoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoCode
     * @return \StructType\CreateBookingRequest
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        if (is_null($promoCode) || (is_array($promoCode) && empty($promoCode))) {
            unset($this->PromoCode);
        } else {
            $this->PromoCode = $promoCode;
        }
        return $this;
    }
    /**
     * Get RefCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefCustomer()
    {
        return isset($this->RefCustomer) ? $this->RefCustomer : null;
    }
    /**
     * Set RefCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refCustomer
     * @return \StructType\CreateBookingRequest
     */
    public function setRefCustomer($refCustomer = null)
    {
        // validation for constraint: string
        if (!is_null($refCustomer) && !is_string($refCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCustomer, true), gettype($refCustomer)), __LINE__);
        }
        if (is_null($refCustomer) || (is_array($refCustomer) && empty($refCustomer))) {
            unset($this->RefCustomer);
        } else {
            $this->RefCustomer = $refCustomer;
        }
        return $this;
    }
    /**
     * Get Segments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSegmentBooking|null
     */
    public function getSegments()
    {
        return isset($this->Segments) ? $this->Segments : null;
    }
    /**
     * Set Segments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSegmentBooking $segments
     * @return \StructType\CreateBookingRequest
     */
    public function setSegments(\ArrayType\ArrayOfSegmentBooking $segments = null)
    {
        if (is_null($segments) || (is_array($segments) && empty($segments))) {
            unset($this->Segments);
        } else {
            $this->Segments = $segments;
        }
        return $this;
    }
    /**
     * Get SpecialServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSpecialService|null
     */
    public function getSpecialServices()
    {
        return isset($this->SpecialServices) ? $this->SpecialServices : null;
    }
    /**
     * Set SpecialServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSpecialService $specialServices
     * @return \StructType\CreateBookingRequest
     */
    public function setSpecialServices(\ArrayType\ArrayOfSpecialService $specialServices = null)
    {
        if (is_null($specialServices) || (is_array($specialServices) && empty($specialServices))) {
            unset($this->SpecialServices);
        } else {
            $this->SpecialServices = $specialServices;
        }
        return $this;
    }
    /**
     * Get WebClassesCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getWebClassesCodes()
    {
        return isset($this->WebClassesCodes) ? $this->WebClassesCodes : null;
    }
    /**
     * Set WebClassesCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $webClassesCodes
     * @return \StructType\CreateBookingRequest
     */
    public function setWebClassesCodes(\ArrayType\ArrayOfstring $webClassesCodes = null)
    {
        if (is_null($webClassesCodes) || (is_array($webClassesCodes) && empty($webClassesCodes))) {
            unset($this->WebClassesCodes);
        } else {
            $this->WebClassesCodes = $webClassesCodes;
        }
        return $this;
    }
}
