<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeCustomerPasswordRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeCustomerPasswordRequest
 * @subpackage Structs
 */
class ChangeCustomerPasswordRequest extends AbstractRequest
{
    /**
     * The ByLoginAndPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerPublicReference
     */
    public $ByLoginAndPassword;
    /**
     * The ByReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerPrivateReference
     */
    public $ByReference;
    /**
     * The NewPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewPassword;
    /**
     * Constructor method for ChangeCustomerPasswordRequest
     * @uses ChangeCustomerPasswordRequest::setByLoginAndPassword()
     * @uses ChangeCustomerPasswordRequest::setByReference()
     * @uses ChangeCustomerPasswordRequest::setNewPassword()
     * @param \StructType\CustomerPublicReference $byLoginAndPassword
     * @param \StructType\CustomerPrivateReference $byReference
     * @param string $newPassword
     */
    public function __construct(\StructType\CustomerPublicReference $byLoginAndPassword = null, \StructType\CustomerPrivateReference $byReference = null, $newPassword = null)
    {
        $this
            ->setByLoginAndPassword($byLoginAndPassword)
            ->setByReference($byReference)
            ->setNewPassword($newPassword);
    }
    /**
     * Get ByLoginAndPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerPublicReference|null
     */
    public function getByLoginAndPassword()
    {
        return isset($this->ByLoginAndPassword) ? $this->ByLoginAndPassword : null;
    }
    /**
     * Set ByLoginAndPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerPublicReference $byLoginAndPassword
     * @return \StructType\ChangeCustomerPasswordRequest
     */
    public function setByLoginAndPassword(\StructType\CustomerPublicReference $byLoginAndPassword = null)
    {
        if (is_null($byLoginAndPassword) || (is_array($byLoginAndPassword) && empty($byLoginAndPassword))) {
            unset($this->ByLoginAndPassword);
        } else {
            $this->ByLoginAndPassword = $byLoginAndPassword;
        }
        return $this;
    }
    /**
     * Get ByReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerPrivateReference|null
     */
    public function getByReference()
    {
        return isset($this->ByReference) ? $this->ByReference : null;
    }
    /**
     * Set ByReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerPrivateReference $byReference
     * @return \StructType\ChangeCustomerPasswordRequest
     */
    public function setByReference(\StructType\CustomerPrivateReference $byReference = null)
    {
        if (is_null($byReference) || (is_array($byReference) && empty($byReference))) {
            unset($this->ByReference);
        } else {
            $this->ByReference = $byReference;
        }
        return $this;
    }
    /**
     * Get NewPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPassword()
    {
        return isset($this->NewPassword) ? $this->NewPassword : null;
    }
    /**
     * Set NewPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPassword
     * @return \StructType\ChangeCustomerPasswordRequest
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        if (is_null($newPassword) || (is_array($newPassword) && empty($newPassword))) {
            unset($this->NewPassword);
        } else {
            $this->NewPassword = $newPassword;
        }
        return $this;
    }
}
